/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.memory.BamLocationDependentJvmMemoryLocation;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationAbstractState;
import proguard.classfile.MethodSignature;

public interface TraceExtractor {
    default public Set<List<BamLocationDependentJvmMemoryLocation>> extractLinearTraces() {
        HashSet<List<BamLocationDependentJvmMemoryLocation>> result = new HashSet<List<BamLocationDependentJvmMemoryLocation>>();
        for (BamLocationDependentJvmMemoryLocation<?> l : this.getEndPoints()) {
            ArrayList<BamLocationDependentJvmMemoryLocation> trace = new ArrayList<BamLocationDependentJvmMemoryLocation>();
            trace.add(l);
            this.traceExtractionIteration(result, trace);
        }
        return result.stream().map(this::removeDuplicateProgramLocations).collect(Collectors.toSet());
    }

    public Collection<BamLocationDependentJvmMemoryLocation<?>> getEndPoints();

    public ProgramLocationDependentReachedSet<JvmCfaNode, JvmCfaEdge, JvmMemoryLocationAbstractState<?>, MethodSignature> getOutputReachedSet();

    default public void traceExtractionIteration(Set<List<BamLocationDependentJvmMemoryLocation>> result, List<BamLocationDependentJvmMemoryLocation> currentTrace) {
        BamLocationDependentJvmMemoryLocation currentNode = currentTrace.get(currentTrace.size() - 1);
        ArrayList<JvmMemoryLocationAbstractState> currentStates = new ArrayList<JvmMemoryLocationAbstractState>();
        for (AbstractState s : this.getOutputReachedSet().getReached(currentNode.getProgramLocation())) {
            if (!((JvmMemoryLocationAbstractState)s).getLocationDependentMemoryLocation().equals(currentNode)) continue;
            currentStates.add((JvmMemoryLocationAbstractState)s);
        }
        for (JvmMemoryLocationAbstractState currentState : currentStates) {
            Set sourceLocations = currentState.getSourceLocations();
            if (sourceLocations.size() == 0) {
                result.add(currentTrace);
            }
            for (BamLocationDependentJvmMemoryLocation l : sourceLocations) {
                if (currentTrace.contains(l)) continue;
                ArrayList<BamLocationDependentJvmMemoryLocation> trace = new ArrayList<BamLocationDependentJvmMemoryLocation>(currentTrace);
                trace.add(l);
                this.traceExtractionIteration(result, trace);
            }
        }
    }

    default public List<BamLocationDependentJvmMemoryLocation> removeDuplicateProgramLocations(List<BamLocationDependentJvmMemoryLocation> trace) {
        ArrayList<BamLocationDependentJvmMemoryLocation> result = new ArrayList<BamLocationDependentJvmMemoryLocation>();
        result.add(trace.get(0));
        for (int i = 1; i < trace.size(); ++i) {
            if (trace.get(i).getProgramLocation().getOffset() < 0 || ((BamLocationDependentJvmMemoryLocation)result.get(result.size() - 1)).getProgramLocation().getOffset() == trace.get(i).getProgramLocation().getOffset() && Objects.equals(((BamLocationDependentJvmMemoryLocation)result.get(result.size() - 1)).getProgramLocation().getSignature(), trace.get(i).getProgramLocation().getSignature())) continue;
            result.add(trace.get(i));
        }
        return result;
    }
}

