/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.processing;

import com.google.common.base.Preconditions;
import com.google.turbine.binder.bound.EnumConstantValue;
import com.google.turbine.binder.bound.TurbineAnnotationValue;
import com.google.turbine.binder.bound.TurbineClassValue;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.model.Const;
import com.google.turbine.processing.ModelFactory;
import com.google.turbine.type.AnnoInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Objects;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;

class TurbineAnnotationProxy
implements InvocationHandler {
    private final ModelFactory factory;
    private final ClassLoader loader;
    private final Class<?> annotationType;
    private final AnnoInfo anno;

    static <A extends Annotation> A create(ModelFactory factory, Class<A> annotationType, AnnoInfo anno) {
        ClassLoader loader = annotationType.getClassLoader();
        if (loader == null) {
            loader = factory.processorLoader();
        }
        return (A)((Annotation)annotationType.cast(Proxy.newProxyInstance(loader, new Class[]{annotationType}, (InvocationHandler)new TurbineAnnotationProxy(factory, loader, annotationType, anno))));
    }

    TurbineAnnotationProxy(ModelFactory factory, ClassLoader loader, Class<?> annotationType, AnnoInfo anno) {
        this.factory = factory;
        this.loader = loader;
        this.annotationType = annotationType;
        this.anno = anno;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        switch (method.getName()) {
            case "hashCode": {
                Preconditions.checkArgument((args == null ? 1 : 0) != 0);
                return this.anno.hashCode();
            }
            case "annotationType": {
                Preconditions.checkArgument((args == null ? 1 : 0) != 0);
                return this.annotationType;
            }
            case "equals": {
                Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0);
                return this.proxyEquals(args[0]);
            }
            case "toString": {
                Preconditions.checkArgument((args == null ? 1 : 0) != 0);
                return this.anno.toString();
            }
        }
        Const value = (Const)this.anno.values().get((Object)method.getName());
        if (value != null) {
            return TurbineAnnotationProxy.constValue(method.getReturnType(), this.factory, this.loader, value);
        }
        for (TypeBoundClass.MethodInfo m : this.factory.getSymbol(this.anno.sym()).methods()) {
            if (!m.name().contentEquals(method.getName())) continue;
            return TurbineAnnotationProxy.constValue(method.getReturnType(), this.factory, this.loader, m.defaultValue());
        }
        throw new NoSuchMethodError(method.getName());
    }

    public boolean proxyEquals(Object other) {
        if (!this.annotationType.isInstance(other)) {
            return false;
        }
        if (!Proxy.isProxyClass(other.getClass())) {
            return false;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(other);
        if (!(handler instanceof TurbineAnnotationProxy)) {
            return false;
        }
        TurbineAnnotationProxy that = (TurbineAnnotationProxy)handler;
        return this.anno.equals(that.anno);
    }

    static Object constValue(Class<?> returnType, ModelFactory factory, ClassLoader loader, Const value) {
        switch (value.kind()) {
            case PRIMITIVE: {
                return ((Const.Value)value).getValue();
            }
            case ARRAY: {
                return TurbineAnnotationProxy.constArrayValue(returnType, factory, loader, (Const.ArrayInitValue)value);
            }
            case ENUM_CONSTANT: {
                return TurbineAnnotationProxy.constEnumValue(loader, (EnumConstantValue)value);
            }
            case ANNOTATION: {
                return TurbineAnnotationProxy.constAnnotationValue(factory, loader, (TurbineAnnotationValue)value);
            }
            case CLASS_LITERAL: {
                return TurbineAnnotationProxy.constClassValue(factory, (TurbineClassValue)value);
            }
        }
        throw new AssertionError((Object)value.kind());
    }

    private static Object constArrayValue(Class<?> returnType, ModelFactory factory, ClassLoader loader, Const.ArrayInitValue value) {
        Class<?> componentType = Objects.requireNonNull(returnType.getComponentType());
        if (componentType.equals(Class.class)) {
            ArrayList<TypeMirror> result = new ArrayList<TypeMirror>();
            for (Const element : value.elements()) {
                result.add(factory.asTypeMirror(((TurbineClassValue)element).type()));
            }
            throw new MirroredTypesException(result);
        }
        Object result = Array.newInstance(componentType, value.elements().size());
        int idx = 0;
        for (Const element : value.elements()) {
            Object v = TurbineAnnotationProxy.constValue(returnType, factory, loader, element);
            Array.set(result, idx++, v);
        }
        return result;
    }

    private static Object constEnumValue(ClassLoader loader, EnumConstantValue value) {
        Class<?> clazz;
        try {
            clazz = loader.loadClass(value.sym().owner().toString());
        }
        catch (ClassNotFoundException e) {
            throw new LinkageError(e.getMessage(), e);
        }
        return Enum.valueOf(clazz.asSubclass(Enum.class), value.sym().name());
    }

    private static Object constAnnotationValue(ModelFactory factory, ClassLoader loader, TurbineAnnotationValue value) {
        try {
            String name = value.sym().binaryName().replace('/', '.');
            Class<Annotation> clazz = Class.forName(name, false, loader).asSubclass(Annotation.class);
            return TurbineAnnotationProxy.create(factory, clazz, value.info());
        }
        catch (ClassNotFoundException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static Object constClassValue(ModelFactory factory, TurbineClassValue value) {
        throw new MirroredTypeException(factory.asTypeMirror(value.type()));
    }
}

