/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.plumelib.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.checkerframework.checker.formatter.qual.FormatBottom;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.LTEqLengthOf;
import org.checkerframework.checker.index.qual.LengthOf;
import org.checkerframework.checker.index.qual.LessThanBottom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundBottom;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexBottom;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.InternedDistinct;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.RegexBottom;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.SignatureBottom;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.common.initializedfields.qual.InitializedFields;
import org.checkerframework.common.initializedfields.qual.InitializedFieldsBottom;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.shaded.dataflow.qual.Pure;

public class CombinationIterator<@FormatBottom T>
implements Iterator<List<T>> {
    private final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) List<T> @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) [] listsOfCandidates;
    private final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Iterator<T> @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) [] iterators;
    private final @LengthOf(value={"listsOfCandidates", "iterators"}) @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @NonNegative @LTEqLengthOf(value={"this.listsOfCandidates", "this.iterators"}) @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int combinationSize;
    private @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) List<T> nextValue;

    public CombinationIterator(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Collection<@FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @SignatureBottom @UnknownThis @InitializedFieldsBottom ? extends @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Collection<T>> collectionsOfCandidates) {
        int size = collectionsOfCandidates.size();
        ArrayList<Collection<T>> listOfCollectionsOfCanditates = new ArrayList<Collection<T>>(collectionsOfCandidates);
        this.listsOfCandidates = new ArrayList[size];
        this.iterators = new Iterator[size];
        this.combinationSize = size;
        this.nextValue = this.combinationSize == 0 ? null : new ArrayList(collectionsOfCandidates.size());
        for (int i = 0; i < this.combinationSize; ++i) {
            Collection<T> userSuppliedCandidates = listOfCollectionsOfCanditates.get(i);
            ArrayList<T> candidates = new ArrayList<T>(userSuppliedCandidates);
            this.listsOfCandidates[i] = candidates;
            Iterator it = candidates.iterator();
            this.iterators[i] = it;
            if (this.nextValue == null) continue;
            if (it.hasNext()) {
                this.nextValue.add(it.next());
                continue;
            }
            this.nextValue = null;
        }
    }

    @Override
    @EnsuresNonNullIf(expression={"nextValue"}, result=true)
    @Pure
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean hasNext(@GuardSatisfied CombinationIterator<T> this) {
        return this.nextValue != null;
    }

    @RequiresNonNull(value={"nextValue"})
    private void advanceNext(@GuardSatisfied CombinationIterator<T> this) {
        for (int i = this.combinationSize - 1; i >= 0; --i) {
            if (this.iterators[i].hasNext()) {
                this.nextValue.set(i, this.iterators[i].next());
                return;
            }
            this.iterators[i] = this.listsOfCandidates[i].iterator();
            this.nextValue.set(i, this.iterators[i].next());
        }
        this.nextValue = null;
    }

    @Override
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) List<T> next(@GuardSatisfied CombinationIterator<T> this) {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ArrayList<T> result = new ArrayList<T>(this.nextValue);
        this.advanceNext();
        return result;
    }

    @Override
    public void remove(@GuardSatisfied CombinationIterator<T> this) {
        throw new UnsupportedOperationException("Remove not implemented for randoop.reflection.SubstitutionEnumerator");
    }
}

