/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.errorprone.VisitorState;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.names.LevenshteinEditDistance;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreePath;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import java.util.Optional;
import javax.annotation.Nullable;

final class Utils {
    static Optional<String> getBestMatch(String to, int maxEditDistance, Iterable<String> choices) {
        String bestMatch = null;
        int minDistance = Integer.MAX_VALUE;
        for (String choice : choices) {
            int distance = LevenshteinEditDistance.getEditDistance((String)to, (String)choice);
            if (distance >= minDistance || distance >= maxEditDistance) continue;
            bestMatch = choice;
            minDistance = distance;
        }
        return Optional.ofNullable(bestMatch);
    }

    static DCTree.DCDocComment getDocComment(VisitorState state, Tree tree) {
        return ((JCTree.JCCompilationUnit)state.getPath().getCompilationUnit()).docComments.getCommentTree((JCTree)tree);
    }

    static SuggestedFix replace(DocTree docTree, String replacement, VisitorState state) {
        DocSourcePositions positions = JavacTrees.instance(state.context).getSourcePositions();
        CompilationUnitTree compilationUnitTree = state.getPath().getCompilationUnit();
        int startPos = Utils.getStartPosition(docTree, state);
        int endPos = (int)positions.getEndPosition(compilationUnitTree, Utils.getDocCommentTree(state), docTree);
        if (endPos == -1) {
            return SuggestedFix.emptyFix();
        }
        return SuggestedFix.replace((int)startPos, (int)endPos, (String)replacement);
    }

    static int getStartPosition(DocTree docTree, VisitorState state) {
        DocSourcePositions positions = JavacTrees.instance(state.context).getSourcePositions();
        CompilationUnitTree compilationUnitTree = state.getPath().getCompilationUnit();
        return (int)positions.getStartPosition(compilationUnitTree, Utils.getDocCommentTree(state), docTree);
    }

    static int getEndPosition(DocTree docTree, VisitorState state) {
        DocSourcePositions positions = JavacTrees.instance(state.context).getSourcePositions();
        CompilationUnitTree compilationUnitTree = state.getPath().getCompilationUnit();
        return (int)positions.getEndPosition(compilationUnitTree, Utils.getDocCommentTree(state), docTree);
    }

    static JCDiagnostic.DiagnosticPosition diagnosticPosition(DocTreePath path, VisitorState state) {
        int startPosition = Utils.getStartPosition(path.getLeaf(), state);
        Tree tree = path.getTreePath().getLeaf();
        if (startPosition == -1) {
            startPosition = ASTHelpers.getStartPosition((Tree)tree);
        }
        return Utils.getDiagnosticPosition(startPosition, tree);
    }

    static JCDiagnostic.DiagnosticPosition getDiagnosticPosition(final int startPosition, final Tree tree) {
        return new JCDiagnostic.DiagnosticPosition(){

            @Override
            public JCTree getTree() {
                return (JCTree)tree;
            }

            @Override
            public int getStartPosition() {
                return startPosition;
            }

            @Override
            public int getPreferredPosition() {
                return startPosition;
            }

            @Override
            public int getEndPosition(EndPosTable endPosTable) {
                return startPosition;
            }
        };
    }

    @Nullable
    static DocTreePath getDocTreePath(VisitorState state) {
        DocCommentTree docCommentTree = Utils.getDocCommentTree(state);
        if (docCommentTree == null) {
            return null;
        }
        return new DocTreePath(state.getPath(), docCommentTree);
    }

    @Nullable
    private static DocCommentTree getDocCommentTree(VisitorState state) {
        return JavacTrees.instance(state.context).getDocCommentTree(state.getPath());
    }

    private Utils() {
    }
}

