/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="InitializeInline", summary="Initializing variables in their declaring statement is clearer, where possible.", severity=BugPattern.SeverityLevel.WARNING)
public final class InitializeInline
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    public Description matchVariable(VariableTree tree, VisitorState state) {
        final Tree declarationParent = state.getPath().getParentPath().getLeaf();
        if (declarationParent instanceof ClassTree) {
            return Description.NO_MATCH;
        }
        final Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (symbol == null || !ASTHelpers.isConsideredFinal((Symbol)symbol)) {
            return Description.NO_MATCH;
        }
        AssignmentTree assignment = (AssignmentTree)new TreePathScanner<AssignmentTree, Void>(){

            @Override
            public AssignmentTree reduce(AssignmentTree a, AssignmentTree b) {
                return a == null ? b : a;
            }

            @Override
            public AssignmentTree visitAssignment(AssignmentTree node, Void unused) {
                if (symbol.equals(ASTHelpers.getSymbol((Tree)node.getVariable()))) {
                    Tree grandParent = this.getCurrentPath().getParentPath().getParentPath().getLeaf();
                    if (this.getCurrentPath().getParentPath().getLeaf() instanceof StatementTree && grandParent.equals(declarationParent)) {
                        return node;
                    }
                }
                return (AssignmentTree)super.visitAssignment(node, null);
            }
        }.scan(state.getPath().getParentPath(), (Void)null);
        if (assignment == null) {
            return Description.NO_MATCH;
        }
        ModifiersTree modifiersTree = tree.getModifiers();
        String modifiers = modifiersTree == null || state.getEndPosition((Tree)modifiersTree) == -1 ? "" : state.getSourceForNode((Tree)modifiersTree) + " ";
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace((Tree)tree, "").prefixWith((Tree)assignment, modifiers + state.getSourceForNode(tree.getType()) + " ").build());
    }
}

