/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@BugPattern(name="AmbiguousMethodReference", summary="Method reference is ambiguous", severity=BugPattern.SeverityLevel.WARNING)
public class AmbiguousMethodReference
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol origin = ASTHelpers.getSymbol((ClassTree)tree);
        Types types = state.getTypes();
        Iterable<Symbol> members = types.membersClosure(ASTHelpers.getType((ClassTree)tree), false).getSymbols();
        Map<String, List> methods = Streams.stream(members).filter(Symbol.MethodSymbol.class::isInstance).map(Symbol.MethodSymbol.class::cast).filter(m -> m.isConstructor() || m.owner.equals(origin)).collect(Collectors.groupingBy(m -> AmbiguousMethodReference.methodReferenceDescriptor(types, m), Collectors.toCollection(ArrayList::new)));
        for (Tree tree2 : tree.getMembers()) {
            List clash;
            Symbol.MethodSymbol msym;
            if (!(tree2 instanceof MethodTree) || this.isSuppressed(msym = ASTHelpers.getSymbol((MethodTree)((MethodTree)tree2))) || (clash = methods.remove(AmbiguousMethodReference.methodReferenceDescriptor(types, msym))) == null) continue;
            int nonPrivateMethodCount = 0;
            for (Symbol.MethodSymbol method : clash) {
                if (method.isPrivate()) continue;
                ++nonPrivateMethodCount;
            }
            if (nonPrivateMethodCount < 2) continue;
            clash.remove(msym);
            clash.removeIf(m -> types.isSubSignature(msym.type, m.type));
            if (clash.isEmpty()) continue;
            String message = String.format("This method's reference is ambiguous, its name and functional interface type are the same as: %s", clash.stream().map(m -> Signatures.prettyMethodSignature((Symbol.ClassSymbol)origin, (Symbol.MethodSymbol)m)).collect(Collectors.joining(", ")));
            state.reportMatch(this.buildDescription(tree2).setMessage(message).build());
        }
        return Description.NO_MATCH;
    }

    private static String methodReferenceDescriptor(Types types, Symbol.MethodSymbol sym) {
        StringBuilder sb = new StringBuilder();
        sb.append(sym.getSimpleName()).append('(');
        if (!sym.isStatic()) {
            sb.append(Signatures.descriptor((Type)sym.owner.type, (Types)types));
        }
        sym.params().stream().map(p -> Signatures.descriptor((Type)p.type, (Types)types)).forEachOrdered(sb::append);
        sb.append(")");
        return sb.toString();
    }
}

