/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import javax.lang.model.element.ElementKind;

@BugPattern(name="RethrowReflectiveOperationExceptionAsLinkageError", summary="Prefer LinkageError for rethrowing ReflectiveOperationException as unchecked", severity=BugPattern.SeverityLevel.WARNING)
public class RethrowReflectiveOperationExceptionAsLinkageError
extends BugChecker
implements BugChecker.ThrowTreeMatcher {
    private static final String ASSERTION_ERROR = "java.lang.AssertionError";
    private static final String REFLECTIVE_OPERATION_EXCEPTION = "java.lang.ReflectiveOperationException";
    private static final Matcher<ExpressionTree> MATCHER = Matchers.constructor().forClass("java.lang.AssertionError");

    public Description matchThrow(ThrowTree throwTree, VisitorState state) {
        if (!MATCHER.matches((Tree)throwTree.getExpression(), state)) {
            return Description.NO_MATCH;
        }
        NewClassTree newClassTree = (NewClassTree)throwTree.getExpression();
        List<? extends ExpressionTree> arguments = newClassTree.getArguments();
        if (arguments.isEmpty() || arguments.size() > 2) {
            return Description.NO_MATCH;
        }
        Symbol cause = ASTHelpers.getSymbol((Tree)((Tree)Iterables.getLast(arguments)));
        if (cause == null || !RethrowReflectiveOperationExceptionAsLinkageError.isReflectiveOperationException(state, cause)) {
            return Description.NO_MATCH;
        }
        String message = arguments.size() == 1 ? String.format("%s.getMessage()", cause.getSimpleName()) : state.getSourceForNode((Tree)arguments.get(0));
        return this.describeMatch(newClassTree, (Fix)SuggestedFix.replace((Tree)newClassTree, (String)String.format("new LinkageError(%s, %s)", message, cause.getSimpleName())));
    }

    private static boolean isReflectiveOperationException(VisitorState state, Symbol symbol) {
        return ASTHelpers.isSameType((Type)symbol.asType(), (Type)state.getTypeFromString(REFLECTIVE_OPERATION_EXCEPTION), (VisitorState)state) && symbol.getKind().equals((Object)ElementKind.EXCEPTION_PARAMETER);
    }
}

