/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@BugPattern(name="UnescapedEntity", summary="Javadoc is interpreted as HTML, so HTML entities such as &, <, > must be escaped. If this finding seems wrong (e.g. is within a @code or @literal tag), check whether the tag could be malformed and not recognised by the compiler.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class UnescapedEntity
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final ImmutableSet<String> PRE_TAGS = ImmutableSet.of((Object)"pre", (Object)"code");
    private static final String TYPE = "[A-Z][a-zA-Z0-9_]*";
    private static final String TYPE_PARAMETERS = "[A-Z][A-Za-z0-9,.& ]+";
    private static final Pattern GENERIC_PATTERN = Pattern.compile(String.format("(%s<%s>|%s<%s<%s>>)", "[A-Z][a-zA-Z0-9_]*", "[A-Z][A-Za-z0-9,.& ]+", "[A-Z][a-zA-Z0-9_]*", "[A-Z][a-zA-Z0-9_]*", "[A-Z][A-Za-z0-9,.& ]+"));
    private static final Pattern SHOULD_NOT_WRAP = Pattern.compile("&[a-zA-Z0-9]+;|&#[0-9]+;|&#x[0-9a-fA-F]+;|\n *\\*\\s*@|\\{@(literal|code)");

    public Description matchClass(ClassTree classTree, VisitorState state) {
        return this.handle(Utils.getDocTreePath(state), state);
    }

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        return this.handle(Utils.getDocTreePath(state), state);
    }

    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        return this.handle(Utils.getDocTreePath(state), state);
    }

    private Description handle(@Nullable DocTreePath path, VisitorState state) {
        if (path == null) {
            return Description.NO_MATCH;
        }
        RangesFinder rangesFinder = new RangesFinder(state);
        rangesFinder.scan(path, null);
        Tokens.Comment comment = ((DCTree.DCDocComment)path.getDocComment()).comment;
        Matcher matcher = GENERIC_PATTERN.matcher(comment.getText());
        TreeRangeSet generics = TreeRangeSet.create();
        while (matcher.find()) {
            generics.add(Range.closedOpen((Comparable)Integer.valueOf(comment.getSourcePos(matcher.start())), (Comparable)Integer.valueOf(comment.getSourcePos(matcher.end()))));
        }
        RangeSet<Integer> emittedFixes = this.fixGenerics((RangeSet<Integer>)generics, (RangeSet<Integer>)rangesFinder.preTags, (RangeSet<Integer>)rangesFinder.dontEmitCodeFix, state);
        new EntityChecker(state, (RangeSet)generics, rangesFinder.preTags, emittedFixes).scan(path, null);
        return Description.NO_MATCH;
    }

    private RangeSet<Integer> fixGenerics(RangeSet<Integer> generics, RangeSet<Integer> preTags, RangeSet<Integer> dontEmitCodeFix, VisitorState state) {
        TreeRangeSet emittedFixes = TreeRangeSet.create();
        for (Range range : generics.asRanges()) {
            if (emittedFixes.intersects(range) || dontEmitCodeFix.intersects(range)) continue;
            Range regionToWrap = preTags.rangeContaining(range.lowerEndpoint());
            if (regionToWrap == null) {
                regionToWrap = range;
            }
            emittedFixes.add(regionToWrap);
            state.reportMatch(this.buildDescription(Utils.getDiagnosticPosition((Integer)range.lowerEndpoint(), state.getPath().getLeaf())).setMessage("This looks like a type with type parameters. The < and > characters here will be interpreted as HTML, which can be avoided by wrapping it in a {@code } tag.").addFix((Fix)UnescapedEntity.wrapInCodeTag((Range<Integer>)regionToWrap)).build());
        }
        return emittedFixes;
    }

    private static SuggestedFix wrapInCodeTag(Range<Integer> containingPre) {
        return SuggestedFix.builder().replace(((Integer)containingPre.lowerEndpoint()).intValue(), ((Integer)containingPre.lowerEndpoint()).intValue(), "{@code ").replace(((Integer)containingPre.upperEndpoint()).intValue(), ((Integer)containingPre.upperEndpoint()).intValue(), "}").build();
    }

    private final class EntityChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;
        private final RangeSet<Integer> generics;
        private final RangeSet<Integer> preTags;
        private final RangeSet<Integer> emittedFixes;

        private EntityChecker(VisitorState state, RangeSet<Integer> generics, RangeSet<Integer> preTags, RangeSet<Integer> emittedFixes) {
            this.state = state;
            this.generics = generics;
            this.preTags = preTags;
            this.emittedFixes = emittedFixes;
        }

        @Override
        public Void visitErroneous(ErroneousTree erroneousTree, Void unused) {
            if (erroneousTree.getBody().equals("&")) {
                this.generateFix("&amp;").ifPresent(arg_0 -> ((VisitorState)this.state).reportMatch(arg_0));
                return (Void)super.visitErroneous(erroneousTree, null);
            }
            if (erroneousTree.getBody().equals("<")) {
                this.generateFix("&lt;").ifPresent(arg_0 -> ((VisitorState)this.state).reportMatch(arg_0));
                return (Void)super.visitErroneous(erroneousTree, null);
            }
            if (erroneousTree.getBody().equals(">")) {
                this.generateFix("&gt;").ifPresent(arg_0 -> ((VisitorState)this.state).reportMatch(arg_0));
                return (Void)super.visitErroneous(erroneousTree, null);
            }
            return (Void)super.visitErroneous(erroneousTree, null);
        }

        private Optional<Description> generateFix(String replacement) {
            int startPosition = Utils.getStartPosition(this.getCurrentPath().getLeaf(), this.state);
            if (this.emittedFixes.contains((Comparable)Integer.valueOf(startPosition))) {
                return Optional.empty();
            }
            Range containingPre = this.preTags.rangeContaining((Comparable)Integer.valueOf(startPosition));
            if (containingPre == null) {
                return this.generics.contains((Comparable)Integer.valueOf(startPosition)) ? Optional.of(this.replacementFix(replacement)) : Optional.empty();
            }
            if (this.emittedFixes.intersects(containingPre)) {
                return Optional.empty();
            }
            this.emittedFixes.add(containingPre);
            SuggestedFix fix = UnescapedEntity.wrapInCodeTag((Range<Integer>)containingPre);
            return Optional.of(UnescapedEntity.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage("This HTML entity is invalid. Enclosing the code in this <pre>/<code> tag with a {@code } block will force Javadoc to interpret HTML literally.").addFix((Fix)fix).build());
        }

        private Description replacementFix(String replacement) {
            return UnescapedEntity.this.describeMatch(Utils.diagnosticPosition(this.getCurrentPath(), this.state), (Fix)Utils.replace(this.getCurrentPath().getLeaf(), replacement, this.state));
        }
    }

    private static final class RangesFinder
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;
        private final RangeSet<Integer> preTags = TreeRangeSet.create();
        private final RangeSet<Integer> dontEmitCodeFix = TreeRangeSet.create();
        private final Deque<Integer> startPosStack = new ArrayDeque<Integer>();
        private boolean containsAnotherTag = false;

        private RangesFinder(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void visitStartElement(StartElementTree startTree, Void unused) {
            if (PRE_TAGS.contains((Object)startTree.getName().toString())) {
                this.startPosStack.offerLast(Utils.getEndPosition(startTree, this.state));
                this.containsAnotherTag = false;
            }
            return (Void)super.visitStartElement(startTree, null);
        }

        @Override
        public Void visitEndElement(EndElementTree endTree, Void unused) {
            if (PRE_TAGS.contains((Object)endTree.getName().toString())) {
                Integer startPos;
                if (!this.containsAnotherTag && (startPos = this.startPosStack.pollLast()) != null) {
                    int endPos = Utils.getStartPosition(endTree, this.state);
                    String source = this.state.getSourceCode().subSequence(startPos, endPos).toString();
                    if (SHOULD_NOT_WRAP.matcher(source).find()) {
                        this.dontEmitCodeFix.add(Range.closed((Comparable)startPos, (Comparable)Integer.valueOf(endPos)));
                    } else {
                        this.preTags.add(Range.closed((Comparable)startPos, (Comparable)Integer.valueOf(endPos)));
                    }
                }
                this.containsAnotherTag = true;
                return (Void)super.visitEndElement(endTree, null);
            }
            return (Void)super.visitEndElement(endTree, null);
        }

        @Override
        public Void visitLink(LinkTree linkTree, Void unused) {
            this.excludeFromCodeFixes(linkTree);
            return (Void)super.visitLink(linkTree, null);
        }

        @Override
        public Void visitLiteral(LiteralTree literalTree, Void unused) {
            this.excludeFromCodeFixes(literalTree);
            return (Void)super.visitLiteral(literalTree, null);
        }

        @Override
        public Void visitSee(SeeTree seeTree, Void unused) {
            this.excludeFromCodeFixes(seeTree);
            return (Void)super.visitSee(seeTree, null);
        }

        private void excludeFromCodeFixes(DocTree tree) {
            int endPos = Utils.getEndPosition(tree, this.state);
            if (endPos != -1) {
                this.dontEmitCodeFix.add(Range.closed((Comparable)Integer.valueOf(Utils.getStartPosition(tree, this.state)), (Comparable)Integer.valueOf(endPos)));
            }
        }
    }
}

