/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="JodaDurationWithMillis", summary="Use of duration.withMillis(long) is not allowed. Please use Duration.millis(long) instead.", explanation="Joda-Time's 'duration.withMillis(long)' method is often a source of bugs because it doesn't mutate the current instance but rather returns a new immutable Duration instance.Please use Duration.millis(long) instead. If your Duration is better expressed in terms of other units, use standardSeconds(long), standardMinutes(long), standardHours(long), or standardDays(long) instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class JodaDurationWithMillis
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onExactClass("org.joda.time.Duration").named("withMillis").withParameters(new String[]{"long"}), Matchers.not((Matcher)Matchers.packageStartsWith((String)"org.joda.time"))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        String replacement = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)builder, (String)"org.joda.time.Duration") + ".millis(";
        ExpressionTree millisArg = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        builder.replace(ASTHelpers.getStartPosition((Tree)tree), ASTHelpers.getStartPosition((Tree)millisArg), replacement);
        return this.describeMatch(tree, (Fix)builder.build());
    }
}

