/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="DescribeMatch", summary="`describeMatch(tree, fix)` is equivalent to and simpler than `buildDescription(tree).addFix(fix).build()`", severity=BugPattern.SeverityLevel.ERROR)
public class DescribeMatch
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> BUILD_DESCRIPTION = MethodMatchers.instanceMethod().onDescendantOf(BugChecker.class.getCanonicalName()).named("buildDescription");
    private static final Matcher<ExpressionTree> ADD_FIX = MethodMatchers.instanceMethod().onDescendantOf(Description.Builder.class.getCanonicalName()).named("addFix");
    private static final Matcher<ExpressionTree> BUILD = MethodMatchers.instanceMethod().onDescendantOf(Description.Builder.class.getCanonicalName()).named("build");

    public Description matchMethodInvocation(MethodInvocationTree build, VisitorState state) {
        if (!BUILD.matches((Tree)build, state)) {
            return Description.NO_MATCH;
        }
        if (DescribeMatch.withinBugChecker(state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree addFix = ASTHelpers.getReceiver((ExpressionTree)build);
        if (!ADD_FIX.matches((Tree)addFix, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree buildDescription = ASTHelpers.getReceiver((ExpressionTree)addFix);
        if (!BUILD_DESCRIPTION.matches((Tree)buildDescription, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(build, (Fix)SuggestedFix.replace((Tree)build, (String)String.format("describeMatch(%s, %s)", DescribeMatch.getArgument(state, buildDescription), DescribeMatch.getArgument(state, addFix))));
    }

    private static boolean withinBugChecker(VisitorState state) {
        return Streams.stream((Iterable)state.getPath()).anyMatch(t -> t instanceof ClassTree && ASTHelpers.getSymbol((Tree)t).getQualifiedName().contentEquals(BugChecker.class.getCanonicalName()));
    }

    private static String getArgument(VisitorState state, ExpressionTree tree) {
        return state.getSourceForNode((Tree)Iterables.getOnlyElement(((MethodInvocationTree)tree).getArguments()));
    }
}

