/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.NoAllocation;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@BugPattern(name="NoAllocation", summary="@NoAllocation was specified on this method, but something was found that would trigger an allocation", severity=BugPattern.SeverityLevel.ERROR)
public class NoAllocationChecker
extends BugChecker
implements BugChecker.AssignmentTreeMatcher,
BugChecker.BinaryTreeMatcher,
BugChecker.CompoundAssignmentTreeMatcher,
BugChecker.EnhancedForLoopTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewArrayTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.ReturnTreeMatcher,
BugChecker.TypeCastTreeMatcher,
BugChecker.UnaryTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final String COMMON_MESSAGE_SUFFIX = "is disallowed in methods annotated with @NoAllocation";
    private static final Matcher<MethodTree> noAllocationMethodMatcher = Matchers.hasAnnotation((String)NoAllocation.class.getName());
    private static final Matcher<MethodInvocationTree> noAllocationMethodInvocationMatcher = Matchers.symbolHasAnnotation((String)NoAllocation.class.getName());
    private static final Matcher<ExpressionTree> anyExpression = Matchers.anything();
    private static final Matcher<StatementTree> anyStatement = Matchers.anything();
    private static final Matcher<VariableTree> anyVariable = Matchers.anything();
    private static final Matcher<ExpressionTree> isString = Matchers.isSameType((String)"java.lang.String");
    private static final Matcher<ExpressionTree> arrayExpression = Matchers.isArrayType();
    private static final Matcher<ExpressionTree> primitiveExpression = Matchers.isPrimitiveType();
    private static final Matcher<ExpressionTree> primitiveArrayExpression = Matchers.isPrimitiveArrayType();
    private static final Set<Tree.Kind> ALL_COMPOUND_OPERATORS = Collections.unmodifiableSet(EnumSet.of(Tree.Kind.AND_ASSIGNMENT, new Tree.Kind[]{Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT}));
    private static final Matcher<Tree> withinThrowOrAnnotation = new Matcher<Tree>(){

        public boolean matches(Tree tree, VisitorState state) {
            for (TreePath path = state.getPath().getParentPath(); path != null; path = path.getParentPath()) {
                Tree node = path.getLeaf();
                state = state.withPath(path);
                switch (node.getKind()) {
                    case METHOD: {
                        return false;
                    }
                    case THROW: 
                    case ANNOTATION: {
                        return true;
                    }
                }
            }
            return false;
        }
    };
    private static final Matcher<NewArrayTree> newArrayMatcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher)});
    private static final Matcher<NewClassTree> newClassMatcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher)});
    private static final Matcher<MethodInvocationTree> methodMatcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.not(noAllocationMethodInvocationMatcher)});
    private static final Matcher<BinaryTree> stringConcatenationMatcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.kindIs((Tree.Kind)Tree.Kind.PLUS), Matchers.binaryTree(anyExpression, isString)});
    private static final Matcher<CompoundAssignmentTree> compoundAssignmentMatcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.compoundAssignment((Tree.Kind)Tree.Kind.PLUS_ASSIGNMENT, isString, anyExpression), Matchers.compoundAssignment(ALL_COMPOUND_OPERATORS, (Matcher)Matchers.not(primitiveExpression), anyExpression)})});
    private static final Matcher<EnhancedForLoopTree> foreachMatcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.enhancedForLoop(anyVariable, arrayExpression, anyStatement)), Matchers.enhancedForLoop((Matcher)Matchers.variableType((Matcher)Matchers.not((Matcher)Matchers.isPrimitiveType())), primitiveArrayExpression, anyStatement)})});
    private static final Matcher<AssignmentTree> boxingAssignment = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.assignment((Matcher)Matchers.not(primitiveExpression), primitiveExpression)});
    private static final Matcher<VariableTree> boxingInitialization = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.variableInitializer(primitiveExpression), Matchers.variableType((Matcher)Matchers.not((Matcher)Matchers.isPrimitiveType()))});
    private static final Matcher<TypeCastTree> boxingCast = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.typeCast((Matcher)Matchers.not((Matcher)Matchers.isPrimitiveType()), primitiveExpression)});
    private static final Matcher<StatementTree> boxingReturn = Matchers.matchExpressionReturn((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod((Matcher)Matchers.allOf((Matcher[])new Matcher[]{noAllocationMethodMatcher, Matchers.methodReturnsNonPrimitiveType()})), Matchers.isPrimitiveType()}));
    private static final Matcher<MethodInvocationTree> boxingInvocation = new Matcher<MethodInvocationTree>(){

        public boolean matches(MethodInvocationTree tree, VisitorState state) {
            if (!Matchers.enclosingMethod((Matcher)noAllocationMethodMatcher).matches((Tree)tree, state)) {
                return false;
            }
            JCTree.JCMethodInvocation methodInvocation = (JCTree.JCMethodInvocation)tree;
            List arguments = methodInvocation.getArguments();
            Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
            List params = methodSymbol.getParameters();
            if (arguments.size() != params.size()) {
                return true;
            }
            int numArgs = arguments.size();
            int i = 0;
            Iterator argument = arguments.iterator();
            Iterator param = params.iterator();
            while (param.hasNext() && argument.hasNext()) {
                JCTree.JCExpression a = (JCTree.JCExpression)argument.next();
                Symbol.VarSymbol p = (Symbol.VarSymbol)param.next();
                if (a.type.isPrimitive() && !p.type.isPrimitive()) {
                    return true;
                }
                if (i == numArgs - 1 && methodSymbol.isVarArgs() && p.type instanceof Type.ArrayType && !state.getTypes().isAssignable(a.type, p.type)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    };
    private static final Matcher<UnaryTree> boxingUnary = new Matcher<UnaryTree>(){

        public boolean matches(UnaryTree tree, VisitorState state) {
            return Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)withinThrowOrAnnotation), Matchers.enclosingMethod((Matcher)noAllocationMethodMatcher), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.POSTFIX_DECREMENT), Matchers.kindIs((Tree.Kind)Tree.Kind.POSTFIX_INCREMENT), Matchers.kindIs((Tree.Kind)Tree.Kind.PREFIX_DECREMENT), Matchers.kindIs((Tree.Kind)Tree.Kind.PREFIX_INCREMENT)})}).matches((Tree)tree, state) && Matchers.not((Matcher)Matchers.isPrimitiveType()).matches((Tree)tree, state);
        }
    };

    public Description matchNewArray(NewArrayTree tree, VisitorState state) {
        if (!newArrayMatcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Allocating a new array with \"new\" or \"{ ... }\" is disallowed in methods annotated with @NoAllocation").build();
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!newClassMatcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Constructing a new object is disallowed in methods annotated with @NoAllocation").build();
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!methodMatcher.matches((Tree)tree, state) && !boxingInvocation.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Calling a method that is not annotated with @NoAllocation, calling a varargs method without exactly matching the signature, or passing a primitive value as non-primitive method argument is disallowed in methods annotated with @NoAllocation").build();
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (Matchers.hasAnnotation(NoAllocation.class).matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        return ASTHelpers.findSuperMethods((Symbol.MethodSymbol)symbol, (Types)state.getTypes()).stream().filter(s -> ASTHelpers.hasAnnotation((Symbol)s, (String)NoAllocation.class.getName(), (VisitorState)state)).findAny().map(s -> {
            String message = String.format("Method overrides %s in %s which is annotated @NoAllocation, it should also be annotated.", s.getSimpleName(), s.owner.getSimpleName());
            return this.buildDescription(tree).setMessage(message).addFix((Fix)SuggestedFix.builder().addImport(NoAllocation.class.getName()).prefixWith((Tree)tree, "@NoAllocation ").build()).build();
        }).orElse(Description.NO_MATCH);
    }

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (!stringConcatenationMatcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("String concatenation allocates a new String, which is disallowed in methods annotated with @NoAllocation").build();
    }

    public Description matchCompoundAssignment(CompoundAssignmentTree tree, VisitorState state) {
        if (!compoundAssignmentMatcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Compound assignment to a String or boxed primitive allocates a new object, which is disallowed in methods annotated with @NoAllocation").build();
    }

    public Description matchEnhancedForLoop(EnhancedForLoopTree tree, VisitorState state) {
        if (!foreachMatcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Iterating over a Collection or iterating over a primitive array using a non-primitive element type will trigger allocation, which is disallowed in methods annotated with @NoAllocation").build();
    }

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        if (!boxingAssignment.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Assigning a primitive value to a non-primitive variable or array element will autobox the value, which is disallowed in methods annotated with @NoAllocation").build();
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (!boxingInitialization.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Initializing a non-primitive variable with a primitive value will autobox the value, which is disallowed in methods annotated with @NoAllocation").build();
    }

    public Description matchTypeCast(TypeCastTree tree, VisitorState state) {
        if (!boxingCast.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Casting a primitive value to a non-primitive type will autobox the value, which is disallowed in methods annotated with @NoAllocation").build();
    }

    public Description matchReturn(ReturnTree tree, VisitorState state) {
        if (!boxingReturn.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Returning a primitive value from a method with a non-primitive return type will autobox the value, which is disallowed in methods annotated with @NoAllocation").build();
    }

    public Description matchUnary(UnaryTree tree, VisitorState state) {
        if (!boxingUnary.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Pre- and post- increment/decrement operations on a non-primitive variable or array element will autobox the result, which is disallowed in methods annotated with @NoAllocation").build();
    }
}

