/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;

public class ReferenceParser {
    private final ParserFactory fac;

    public ReferenceParser(ParserFactory parserFactory) {
        this.fac = parserFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference parse(String string) throws ParseException {
        List<JCTree> list;
        Name name;
        JCTree jCTree;
        Log.DeferredDiagnosticHandler deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.fac.log);
        try {
            int n = string.indexOf("#");
            int n2 = string.indexOf("(", n + 1);
            if (n == -1) {
                if (n2 == -1) {
                    jCTree = this.parseType(string);
                    name = null;
                } else {
                    jCTree = null;
                    name = this.parseMember(string.substring(0, n2));
                }
            } else {
                jCTree = n == 0 ? null : this.parseType(string.substring(0, n));
                name = n2 == -1 ? this.parseMember(string.substring(n + 1)) : this.parseMember(string.substring(n + 1, n2));
            }
            if (n2 < 0) {
                list = null;
            } else {
                int n3 = string.indexOf(")", n2);
                if (n3 != string.length() - 1) {
                    throw new ParseException("dc.ref.bad.parens");
                }
                list = this.parseParams(string.substring(n2 + 1, n3));
            }
            if (!deferredDiagnosticHandler.getDiagnostics().isEmpty()) {
                throw new ParseException("dc.ref.syntax.error");
            }
        }
        finally {
            this.fac.log.popDiagnosticHandler(deferredDiagnosticHandler);
        }
        return new Reference(jCTree, name, list);
    }

    private JCTree parseType(String string) throws ParseException {
        JavacParser javacParser = this.fac.newParser(string, false, false, false);
        JCTree.JCExpression jCExpression = javacParser.parseType();
        if (javacParser.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return jCExpression;
    }

    private Name parseMember(String string) throws ParseException {
        JavacParser javacParser = this.fac.newParser(string, false, false, false);
        Name name = javacParser.ident();
        if (javacParser.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return name;
    }

    private List<JCTree> parseParams(String string) throws ParseException {
        if (string.trim().isEmpty()) {
            return List.nil();
        }
        JavacParser javacParser = this.fac.newParser(string.replace("...", "[]"), false, false, false);
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        listBuffer.add(javacParser.parseType());
        if (javacParser.token().kind == Tokens.TokenKind.IDENTIFIER) {
            javacParser.nextToken();
        }
        while (javacParser.token().kind == Tokens.TokenKind.COMMA) {
            javacParser.nextToken();
            listBuffer.add(javacParser.parseType());
            if (javacParser.token().kind != Tokens.TokenKind.IDENTIFIER) continue;
            javacParser.nextToken();
        }
        if (javacParser.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return listBuffer.toList();
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = 0L;

        ParseException(String string) {
            super(string);
        }
    }

    public static class Reference {
        public final JCTree qualExpr;
        public final Name member;
        public final List<JCTree> paramTypes;

        Reference(JCTree jCTree, Name name, List<JCTree> list) {
            this.qualExpr = jCTree;
            this.member = name;
            this.paramTypes = list;
        }
    }
}

