/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.parse;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.parse.Lexer;
import com.google.turbine.parse.SavedToken;
import com.google.turbine.parse.Token;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class VariableInitializerParser {
    final ArrayDeque<Integer> ltIndices = new ArrayDeque();
    final ArrayDeque<Integer> commaIndices = new ArrayDeque();
    List<SavedToken> tokens = new ArrayList<SavedToken>();
    List<Integer> commas = new ArrayList<Integer>();
    public Token token;
    FieldInitState state = FieldInitState.START;
    int depth = 0;
    final Lexer lexer;

    public VariableInitializerParser(Token token, Lexer lexer) {
        this.token = token;
        this.lexer = lexer;
    }

    private void next() {
        this.token = this.lexer.next();
    }

    public List<List<SavedToken>> parseInitializers() {
        block21: while (true) {
            switch (this.token) {
                case IDENT: {
                    this.save();
                    this.next();
                    if (this.state != FieldInitState.START || this.token != Token.LT) continue block21;
                    this.state = FieldInitState.TYPE;
                    this.depth = 1;
                    this.ltIndices.clear();
                    this.commaIndices.clear();
                    this.ltIndices.addLast(this.tokens.size());
                    this.commaIndices.addLast(this.commas.size());
                    this.save();
                    this.next();
                    continue block21;
                }
                case LT: {
                    if (this.state == FieldInitState.TYPE) {
                        ++this.depth;
                        this.ltIndices.addLast(this.tokens.size());
                        this.commaIndices.addLast(this.commas.size());
                    }
                    this.save();
                    this.next();
                    continue block21;
                }
                case GTGTGT: {
                    this.save();
                    this.next();
                    this.dropBracks(3);
                    continue block21;
                }
                case GTGT: {
                    this.save();
                    this.next();
                    this.dropBracks(2);
                    continue block21;
                }
                case GT: {
                    this.save();
                    this.next();
                    this.dropBracks(1);
                    continue block21;
                }
                case LPAREN: {
                    this.save();
                    this.next();
                    this.dropParens();
                    continue block21;
                }
                case LBRACE: {
                    this.save();
                    this.next();
                    this.dropBraces();
                    continue block21;
                }
                case SEMI: {
                    switch (this.state) {
                        case START: 
                        case TYPE: {
                            break block21;
                        }
                    }
                    this.save();
                    this.next();
                    continue block21;
                }
                case COMMA: {
                    this.save();
                    this.next();
                    switch (this.state) {
                        case START: 
                        case TYPE: {
                            this.commas.add(this.tokens.size());
                        }
                    }
                    continue block21;
                }
                case DOT: {
                    this.save();
                    this.next();
                    this.dropTypeArguments();
                    continue block21;
                }
                case NEW: {
                    this.save();
                    this.next();
                    this.dropTypeArguments();
                    while (true) {
                        if (this.token != Token.IDENT) continue block21;
                        this.save();
                        this.next();
                        this.dropTypeArguments();
                        if (this.token != Token.DOT) continue block21;
                        this.next();
                    }
                }
                case COLONCOLON: {
                    this.save();
                    this.next();
                    this.dropTypeArguments();
                    if (this.token != Token.NEW) continue block21;
                    this.next();
                    continue block21;
                }
                case EOF: {
                    break block21;
                }
                default: {
                    this.save();
                    this.next();
                    continue block21;
                }
            }
            break;
        }
        ArrayList<List<SavedToken>> result = new ArrayList<List<SavedToken>>();
        int start = 0;
        for (int idx : this.commas) {
            result.add((List<SavedToken>)ImmutableList.builder().addAll(this.tokens.subList(start, idx - 1)).add((Object)new SavedToken(Token.EOF, null, this.tokens.get((int)(idx - 1)).position)).build());
            start = idx;
        }
        result.add((List<SavedToken>)ImmutableList.builder().addAll(this.tokens.subList(start, this.tokens.size())).add((Object)new SavedToken(Token.EOF, null, this.lexer.position())).build());
        return result;
    }

    private void dropParens() {
        int depth = 1;
        block5: while (depth > 0) {
            switch (this.token) {
                case LPAREN: {
                    this.save();
                    this.next();
                    ++depth;
                    continue block5;
                }
                case RPAREN: {
                    this.save();
                    this.next();
                    --depth;
                    continue block5;
                }
                case EOF: {
                    throw this.error(TurbineError.ErrorKind.UNEXPECTED_EOF, new Object[0]);
                }
            }
            this.save();
            this.next();
        }
    }

    private void dropBraces() {
        int depth = 1;
        block5: while (depth > 0) {
            switch (this.token) {
                case LBRACE: {
                    this.save();
                    this.next();
                    ++depth;
                    continue block5;
                }
                case RBRACE: {
                    this.save();
                    this.next();
                    --depth;
                    continue block5;
                }
                case EOF: {
                    throw this.error(TurbineError.ErrorKind.UNEXPECTED_EOF, new Object[0]);
                }
            }
            this.save();
            this.next();
        }
    }

    private void save() {
        this.tokens.add(new SavedToken(this.token, this.lexer.stringValue(), this.lexer.position()));
    }

    private void dropBracks(int many) {
        if (this.state != FieldInitState.TYPE) {
            return;
        }
        if (this.depth <= many) {
            this.state = FieldInitState.START;
        }
        this.depth -= many;
        int lastType = -1;
        int lastComma = -1;
        for (int i = 0; i < many; ++i) {
            if (this.ltIndices.isEmpty()) {
                throw this.error(TurbineError.ErrorKind.UNEXPECTED_TOKEN, ">");
            }
            lastType = this.ltIndices.removeLast();
            lastComma = this.commaIndices.removeLast();
        }
        switch (this.token) {
            case DOT: 
            case COLONCOLON: {
                this.tokens = this.tokens.subList(0, lastType);
                this.commas = this.commas.subList(0, lastComma);
                break;
            }
        }
    }

    private void dropTypeArguments() {
        if (this.token != Token.LT) {
            return;
        }
        this.next();
        int depth = 1;
        block7: while (depth > 0) {
            switch (this.token) {
                case LT: {
                    ++depth;
                    this.next();
                    continue block7;
                }
                case GTGTGT: {
                    depth -= 3;
                    this.next();
                    continue block7;
                }
                case GTGT: {
                    depth -= 2;
                    this.next();
                    continue block7;
                }
                case GT: {
                    --depth;
                    this.next();
                    continue block7;
                }
                case EOF: {
                    throw this.error(TurbineError.ErrorKind.UNEXPECTED_EOF, new Object[0]);
                }
            }
            this.next();
        }
    }

    @CheckReturnValue
    private TurbineError error(TurbineError.ErrorKind kind, Object ... args) {
        return TurbineError.format(this.lexer.source(), Math.min(this.lexer.position(), this.lexer.source().source().length() - 1), kind, args);
    }

    static enum FieldInitState {
        START,
        TYPE;

    }
}

