/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.Reachability;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.regex.Pattern;

@BugPattern(name="FallThrough", altNames={"fallthrough"}, summary="Switch case may fall through", severity=BugPattern.SeverityLevel.WARNING)
public class FallThrough
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    private static final Pattern FALL_THROUGH_PATTERN = Pattern.compile("\\bfalls?.?through\\b", 2);

    public Description matchSwitch(SwitchTree tree, VisitorState state) {
        PeekingIterator it = Iterators.peekingIterator(((JCTree.JCSwitch)tree).cases.iterator());
        while (it.hasNext()) {
            JCTree.JCCase caseTree = (JCTree.JCCase)it.next();
            if (!it.hasNext()) break;
            JCTree.JCCase next = (JCTree.JCCase)it.peek();
            if (caseTree.stats.isEmpty()) continue;
            boolean completes = Reachability.canCompleteNormally((StatementTree)((StatementTree)Iterables.getLast(caseTree.stats)));
            int endPos = FallThrough.caseEndPosition(state, caseTree);
            if (endPos == -1) break;
            String comments = state.getSourceCode().subSequence(endPos, next.getStartPosition()).toString().trim();
            if (completes && !FALL_THROUGH_PATTERN.matcher(comments).find()) {
                state.reportMatch(this.buildDescription(next).setMessage("Execution may fall through from the previous case; add a `// fall through` comment before this line if it was deliberate").build());
                continue;
            }
            if (completes || !FALL_THROUGH_PATTERN.matcher(comments).find()) continue;
            state.reportMatch(this.buildDescription(next).setMessage("Switch case has 'fall through' comment, but execution cannot fall through from the previous case").build());
        }
        return Description.NO_MATCH;
    }

    private static int caseEndPosition(VisitorState state, JCTree.JCCase caseTree) {
        JCTree.JCStatement only;
        if (caseTree.stats.size() == 1 && (only = (JCTree.JCStatement)Iterables.getOnlyElement(caseTree.stats)).hasTag(JCTree.Tag.BLOCK)) {
            BlockTree blockTree = (BlockTree)((Object)only);
            return blockTree.getStatements().isEmpty() ? ((JCTree)((Object)blockTree)).getStartPosition() : state.getEndPosition((Tree)Iterables.getLast(blockTree.getStatements()));
        }
        return state.getEndPosition((Tree)caseTree);
    }
}

