/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteArrayDataOutput;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ConstantPool;
import com.google.turbine.model.Const;
import java.util.Map;

public class AnnotationWriter {
    final ConstantPool pool;
    final ByteArrayDataOutput output;

    public AnnotationWriter(ConstantPool pool, ByteArrayDataOutput output) {
        this.pool = pool;
        this.output = output;
    }

    public void writeAnnotation(ClassFile.AnnotationInfo annotation) {
        this.output.writeShort(this.pool.utf8(annotation.typeName()));
        this.output.writeShort(annotation.elementValuePairs().size());
        for (Map.Entry<String, ClassFile.AnnotationInfo.ElementValue> entry : annotation.elementValuePairs().entrySet()) {
            this.output.writeShort(this.pool.utf8(entry.getKey()));
            this.writeElementValue(entry.getValue());
        }
    }

    void writeElementValue(ClassFile.AnnotationInfo.ElementValue value) {
        switch (value.kind()) {
            case CONST: {
                this.writeConstElementValue(((ClassFile.AnnotationInfo.ElementValue.ConstValue)value).value());
                break;
            }
            case ENUM: {
                this.writeEnumElementValue((ClassFile.AnnotationInfo.ElementValue.EnumConstValue)value);
                break;
            }
            case CLASS: {
                this.writeClassElementValue((ClassFile.AnnotationInfo.ElementValue.ConstTurbineClassValue)value);
                break;
            }
            case ARRAY: {
                this.writeArrayElementValue((ClassFile.AnnotationInfo.ElementValue.ArrayValue)value);
                break;
            }
            case ANNOTATION: {
                this.writeAnnotationElementValue((ClassFile.AnnotationInfo.ElementValue.ConstTurbineAnnotationValue)value);
            }
        }
    }

    private void writeConstElementValue(Const.Value value) {
        switch (value.constantTypeKind()) {
            case BYTE: {
                this.writeConst('B', this.pool.integer(value.asInteger().value()));
                break;
            }
            case CHAR: {
                this.writeConst('C', this.pool.integer(value.asInteger().value()));
                break;
            }
            case SHORT: {
                this.writeConst('S', this.pool.integer(value.asInteger().value()));
                break;
            }
            case DOUBLE: {
                this.writeConst('D', this.pool.doubleInfo(value.asDouble().value()));
                break;
            }
            case FLOAT: {
                this.writeConst('F', this.pool.floatInfo(value.asFloat().value()));
                break;
            }
            case INT: {
                this.writeConst('I', this.pool.integer(value.asInteger().value()));
                break;
            }
            case LONG: {
                this.writeConst('J', this.pool.longInfo(value.asLong().value()));
                break;
            }
            case STRING: {
                this.writeConst('s', this.pool.utf8(value.asString().value()));
                break;
            }
            case BOOLEAN: {
                this.writeConst('Z', this.pool.integer(value.asBoolean().value() ? 1 : 0));
                break;
            }
            default: {
                throw new AssertionError((Object)value.constantTypeKind());
            }
        }
    }

    private void writeConst(char tag, int index) {
        this.output.writeByte((int)tag);
        this.output.writeShort(index);
    }

    private void writeEnumElementValue(ClassFile.AnnotationInfo.ElementValue.EnumConstValue value) {
        this.output.writeByte(101);
        this.output.writeShort(this.pool.utf8(value.typeName()));
        this.output.writeShort(this.pool.utf8(value.constName()));
    }

    private void writeClassElementValue(ClassFile.AnnotationInfo.ElementValue.ConstTurbineClassValue value) {
        this.output.writeByte(99);
        this.output.writeShort(this.pool.utf8(value.className()));
    }

    private void writeArrayElementValue(ClassFile.AnnotationInfo.ElementValue.ArrayValue value) {
        this.output.writeByte(91);
        this.output.writeShort(value.elements().size());
        for (ClassFile.AnnotationInfo.ElementValue elementValue : value.elements()) {
            this.writeElementValue(elementValue);
        }
    }

    private void writeAnnotationElementValue(ClassFile.AnnotationInfo.ElementValue.ConstTurbineAnnotationValue value) {
        this.output.writeByte(64);
        this.writeAnnotation(value.annotation());
    }

    public void writeTypeAnnotation(ClassFile.TypeAnnotationInfo annotation) {
        this.output.writeByte(annotation.targetType().tag());
        this.writeTypeAnnotationTarget(annotation.target());
        this.writePath(annotation.path());
        this.writeAnnotation(annotation.anno());
    }

    private void writePath(ClassFile.TypeAnnotationInfo.TypePath path) {
        ImmutableList<ClassFile.TypeAnnotationInfo.TypePath> flat = path.flatten();
        this.output.writeByte(flat.size());
        for (ClassFile.TypeAnnotationInfo.TypePath curr : flat) {
            this.output.writeByte((int)curr.tag());
            this.output.writeByte(curr.typeArgumentIndex());
        }
    }

    private void writeTypeAnnotationTarget(ClassFile.TypeAnnotationInfo.Target target) {
        switch (target.kind()) {
            case EMPTY: {
                break;
            }
            case TYPE_PARAMETER: {
                this.output.writeByte(((ClassFile.TypeAnnotationInfo.TypeParameterTarget)target).index());
                break;
            }
            case FORMAL_PARAMETER: {
                this.output.writeByte(((ClassFile.TypeAnnotationInfo.FormalParameterTarget)target).index());
                break;
            }
            case THROWS: {
                this.output.writeShort(((ClassFile.TypeAnnotationInfo.ThrowsTarget)target).index());
                break;
            }
            case SUPERTYPE: {
                this.output.writeShort(((ClassFile.TypeAnnotationInfo.SuperTypeTarget)target).index());
                break;
            }
            case TYPE_PARAMETER_BOUND: {
                ClassFile.TypeAnnotationInfo.TypeParameterBoundTarget typeParameterBoundTarget = (ClassFile.TypeAnnotationInfo.TypeParameterBoundTarget)target;
                this.output.writeByte(typeParameterBoundTarget.typeParameterIndex());
                this.output.writeByte(typeParameterBoundTarget.boundIndex());
            }
        }
    }
}

