/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_ThrowSpecificExceptions_AbstractLikeException;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;

@BugPattern(name="ThrowSpecificExceptions", summary="Consider throwing more specific exceptions rather than (e.g.) RuntimeException. Throwing generic exceptions forces any users of the API that wish to handle the failure mode to catch very non-specific exceptions that convey little information.", severity=BugPattern.SeverityLevel.WARNING)
public final class ThrowSpecificExceptions
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final ImmutableList<AbstractLikeException> ABSTRACT_LIKE_EXCEPTIONS = ImmutableList.of((Object)AbstractLikeException.of(RuntimeException.class, IllegalStateException.class), (Object)AbstractLikeException.of(Throwable.class, AssertionError.class), (Object)AbstractLikeException.of(Error.class, AssertionError.class));

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (tree.getClassBody() != null || !(state.getPath().getParentPath().getLeaf() instanceof ThrowTree) || state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        for (AbstractLikeException abstractLikeException : ABSTRACT_LIKE_EXCEPTIONS) {
            if (!abstractLikeException.matcher().matches((Tree)tree, state)) continue;
            SuggestedFix.Builder fix = SuggestedFix.builder();
            String className = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)abstractLikeException.replacement());
            return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree.getIdentifier(), (String)className));
        }
        return Description.NO_MATCH;
    }

    @AutoValue
    static abstract class AbstractLikeException {
        AbstractLikeException() {
        }

        abstract Matcher<ExpressionTree> matcher();

        abstract String replacement();

        static AbstractLikeException of(Class<?> abstractLikeException, Class<?> replacement) {
            return new AutoValue_ThrowSpecificExceptions_AbstractLikeException((Matcher<ExpressionTree>)Matchers.constructor().forClass(abstractLikeException.getName()), replacement.getName());
        }
    }
}

