/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.processing;

import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.ScopedErrorReport;
import android.databinding.tool.store.Location;
import android.databinding.tool.util.L;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ScopedException
extends RuntimeException {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\\r?\\n");
    private static final String ERROR_LOG_PREFIX = "[databinding] ";
    private static boolean sEncodeOutput = false;
    private ScopedErrorReport mScopedErrorReport;
    private String mScopeLog;

    public ScopedException(String message, Object ... args) {
        super(message == null ? "unknown data binding exception" : (args.length == 0 ? message : String.format(message, args)));
        this.mScopedErrorReport = Scope.createReport();
        this.mScopeLog = L.isDebugEnabled() ? Scope.produceScopeLog() : null;
    }

    ScopedException(String message, ScopedErrorReport scopedErrorReport) {
        super(message);
        this.mScopedErrorReport = scopedErrorReport;
    }

    public String getBareMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        return sEncodeOutput ? this.createEncodedMessage() : this.createHumanReadableMessage();
    }

    public String createHumanReadableMessage() {
        ScopedErrorReport scopedError = this.getScopedErrorReport();
        StringBuilder sb = new StringBuilder();
        sb.append("ERROR: ").append(super.getMessage()).append("\n\n").append("file://").append(scopedError.getFilePath());
        if (scopedError.getLocations() != null && scopedError.getLocations().size() > 0) {
            sb.append(" Line:").append(scopedError.getLocations().get((int)0).startLine);
        }
        sb.append("\n");
        return sb.toString();
    }

    private String createEncodedMessage() {
        ScopedErrorReport scopedError = this.getScopedErrorReport();
        EncodedMessage encoded = new EncodedMessage(super.getMessage(), scopedError.getFilePath());
        if (scopedError.getLocations() != null) {
            for (Location location : scopedError.getLocations()) {
                encoded.positions.add(new FileLocation(location));
            }
        }
        Gson gson = new Gson();
        return ERROR_LOG_PREFIX + gson.toJson((Object)encoded);
    }

    public ScopedErrorReport getScopedErrorReport() {
        return this.mScopedErrorReport;
    }

    public boolean isValid() {
        return this.mScopedErrorReport.isValid();
    }

    private static ScopedException parseJson(String jsonError) throws JsonSyntaxException {
        Gson gson = new Gson();
        EncodedMessage encoded = (EncodedMessage)gson.fromJson(jsonError, EncodedMessage.class);
        List<Location> locations = encoded.positions.stream().map(FileLocation::toLocation).collect(Collectors.toList());
        return new ScopedException(encoded.message, new ScopedErrorReport(Strings.isNullOrEmpty((String)encoded.filePath) ? null : encoded.filePath, locations));
    }

    public static List<ScopedException> extractErrors(String output) {
        Iterable lines = Splitter.on((Pattern)NEWLINE_PATTERN).omitEmptyStrings().trimResults().split((CharSequence)output);
        ArrayList<ScopedException> errors = new ArrayList<ScopedException>();
        for (String line : lines) {
            if (!line.contains(ERROR_LOG_PREFIX)) continue;
            line = line.substring(line.indexOf(ERROR_LOG_PREFIX) + ERROR_LOG_PREFIX.length());
            try {
                errors.add(ScopedException.parseJson(line));
            }
            catch (JsonSyntaxException jsonSyntaxException) {}
        }
        return errors;
    }

    public static void encodeOutput(boolean encodeOutput) {
        sEncodeOutput = encodeOutput;
    }

    public static boolean isEncodeOutput() {
        return sEncodeOutput;
    }

    private static final class EncodedMessage {
        @SerializedName(value="msg")
        public final String message;
        @SerializedName(value="file")
        public final String filePath;
        @SerializedName(value="pos")
        public final List<FileLocation> positions = new ArrayList<FileLocation>();

        private EncodedMessage(String message, String filePath) {
            this.message = message;
            this.filePath = filePath;
        }
    }

    private static final class FileLocation {
        @SerializedName(value="line0")
        public final int lineStart;
        @SerializedName(value="col0")
        public final int colStart;
        @SerializedName(value="line1")
        public final int lineEnd;
        @SerializedName(value="col1")
        public final int colEnd;

        private FileLocation(Location location) {
            this.lineStart = location.startLine;
            this.colStart = location.startOffset;
            this.lineEnd = location.endLine;
            this.colEnd = location.endOffset;
        }

        public Location toLocation() {
            return new Location(this.lineStart, this.colStart, this.lineEnd, this.colEnd);
        }
    }
}

