/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.refaster.AutoValue_ExpressionTemplate;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.ExpressionTemplateMatch;
import com.google.errorprone.refaster.ImportPolicy;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.Template;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UPlaceholderExpression;
import com.google.errorprone.refaster.UPlaceholderStatement;
import com.google.errorprone.refaster.UPrimitiveType;
import com.google.errorprone.refaster.UType;
import com.google.errorprone.refaster.UTypeVar;
import com.google.errorprone.refaster.Unifiable;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.refaster.annotation.AlsoNegation;
import com.google.errorprone.refaster.annotation.UseImportPolicy;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Warner;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@AutoValue
public abstract class ExpressionTemplate
extends Template<ExpressionTemplateMatch>
implements Unifiable<JCTree.JCExpression> {
    private static final Logger logger = Logger.getLogger(ExpressionTemplate.class.toString());
    static final TreeScanner<Boolean, Unifier> PLACEHOLDER_VERIFIER = new TreeScanner<Boolean, Unifier>(){

        @Override
        public Boolean reduce(Boolean a, Boolean b) {
            return ExpressionTemplate.trueOrNull(a) && ExpressionTemplate.trueOrNull(b);
        }

        @Override
        public Boolean visitOther(Tree t, Unifier u) {
            if (t instanceof UPlaceholderExpression) {
                return ((UPlaceholderExpression)t).reverify(u);
            }
            if (t instanceof UPlaceholderStatement) {
                return ((UPlaceholderStatement)t).reverify(u);
            }
            return (Boolean)super.visitOther(t, u);
        }
    };

    public static ExpressionTemplate create(UExpression expression, UType returnType) {
        return ExpressionTemplate.create((Map<String, ? extends UType>)ImmutableMap.of(), expression, returnType);
    }

    public static ExpressionTemplate create(Map<String, ? extends UType> expressionArgumentTypes, UExpression expression, UType returnType) {
        return ExpressionTemplate.create((ImmutableClassToInstanceMap<Annotation>)ImmutableClassToInstanceMap.of(), (Iterable<UTypeVar>)ImmutableList.of(), expressionArgumentTypes, expression, returnType);
    }

    public static ExpressionTemplate create(ImmutableClassToInstanceMap<Annotation> annotations, Iterable<UTypeVar> typeVariables, Map<String, ? extends UType> expressionArgumentTypes, UExpression expression, UType returnType) {
        return new AutoValue_ExpressionTemplate(annotations, (ImmutableList<UTypeVar>)ImmutableList.copyOf(typeVariables), (ImmutableMap<String, UType>)ImmutableMap.copyOf(expressionArgumentTypes), expression, returnType);
    }

    abstract UExpression expression();

    abstract UType returnType();

    public boolean generateNegation() {
        return this.annotations().containsKey(AlsoNegation.class);
    }

    public ExpressionTemplate negation() {
        Preconditions.checkState((boolean)this.returnType().equals(UPrimitiveType.BOOLEAN), (String)"Return type must be boolean to generate negation, but was %s", (Object)this.returnType());
        return ExpressionTemplate.create(this.annotations(), this.templateTypeVariables(), this.expressionArgumentTypes(), this.expression().negate(), this.returnType());
    }

    @Override
    public Iterable<ExpressionTemplateMatch> match(JCTree target, Context context) {
        JCTree.JCExpression targetExpr;
        Optional<Unifier> unifier;
        if (target instanceof JCTree.JCExpression && (unifier = this.unify(targetExpr = (JCTree.JCExpression)target, new Unifier(context)).first()).isPresent()) {
            return ImmutableList.of((Object)new ExpressionTemplateMatch(targetExpr, (Unifier)unifier.get()));
        }
        return ImmutableList.of();
    }

    static boolean trueOrNull(@Nullable Boolean b) {
        return b == null || b != false;
    }

    @Override
    public Choice<Unifier> unify(final JCTree.JCExpression target, Unifier unifier) {
        return this.expression().unify(target, unifier).condition((Predicate<Unifier>)((Predicate)u -> ExpressionTemplate.trueOrNull(PLACEHOLDER_VERIFIER.scan(this.expression(), (Unifier)u)))).thenOption(new Function<Unifier, Optional<Unifier>>(){

            public Optional<Unifier> apply(Unifier unifier) {
                Inliner inliner = unifier.createInliner();
                try {
                    List<Type> expectedTypes = ExpressionTemplate.this.expectedTypes(inliner);
                    List<Type> actualTypes = ExpressionTemplate.this.actualTypes(inliner);
                    if (target.type.getTag() != TypeTag.VOID) {
                        expectedTypes = expectedTypes.prepend((Type)ExpressionTemplate.this.returnType().inline(inliner));
                        Type ty = target.type;
                        if (target.getKind() == Tree.Kind.CONDITIONAL_EXPRESSION) {
                            JCTree.JCConditional cond = (JCTree.JCConditional)target;
                            Type trueTy = cond.truepart.type;
                            Type falseTy = cond.falsepart.type;
                            ty = trueTy.getTag() == TypeTag.BOT ? falseTy : (falseTy.getTag() == TypeTag.BOT ? trueTy : Types.instance(unifier.getContext()).lub(trueTy, falseTy));
                        }
                        actualTypes = actualTypes.prepend(ty);
                    }
                    return ExpressionTemplate.this.typecheck(unifier, inliner, new Warner(target), expectedTypes, actualTypes);
                }
                catch (CouldNotResolveImportException e) {
                    logger.log(Level.FINE, "Failure to resolve import", e);
                    return Optional.absent();
                }
            }
        });
    }

    @Override
    public Fix replace(ExpressionTemplateMatch match) {
        Inliner inliner = match.createInliner();
        Context context = inliner.getContext();
        if (this.annotations().containsKey(UseImportPolicy.class)) {
            ImportPolicy.bind(context, ((UseImportPolicy)this.annotations().getInstance(UseImportPolicy.class)).value());
        } else {
            ImportPolicy.bind(context, ImportPolicy.IMPORT_TOP_LEVEL);
        }
        int prec = ExpressionTemplate.getPrecedence(match.getLocation(), context);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        try {
            StringWriter writer = new StringWriter();
            ExpressionTemplate.pretty(inliner.getContext(), writer).printExpr((JCTree)this.expression().inline(inliner), prec);
            fix.replace((Tree)match.getLocation(), writer.toString());
        }
        catch (CouldNotResolveImportException e) {
            logger.log(Level.SEVERE, "Failure to resolve in replacement", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ExpressionTemplate.addImports(inliner, fix);
    }

    private static int getPrecedence(JCTree leaf, Context context) {
        JCTree.JCCompilationUnit comp = context.get(JCTree.JCCompilationUnit.class);
        JCTree parent = (JCTree)TreeInfo.pathFor((JCTree)leaf, (JCTree.JCCompilationUnit)comp).get(1);
        if (parent instanceof JCTree.JCConditional) {
            JCTree.JCConditional conditional = (JCTree.JCConditional)parent;
            return 3 + (conditional.cond == leaf ? 1 : 0);
        }
        if (parent instanceof JCTree.JCAssign) {
            JCTree.JCAssign assign = (JCTree.JCAssign)parent;
            return 1 + (assign.lhs == leaf ? 1 : 0);
        }
        if (parent instanceof JCTree.JCAssignOp) {
            JCTree.JCAssignOp assignOp = (JCTree.JCAssignOp)parent;
            return 2 + (assignOp.lhs == leaf ? 1 : 0);
        }
        if (parent instanceof JCTree.JCUnary) {
            return TreeInfo.opPrec(parent.getTag());
        }
        if (parent instanceof JCTree.JCBinary) {
            JCTree.JCBinary binary = (JCTree.JCBinary)parent;
            return TreeInfo.opPrec(parent.getTag()) + (binary.rhs == leaf ? 1 : 0);
        }
        if (parent instanceof JCTree.JCTypeCast) {
            JCTree.JCTypeCast typeCast = (JCTree.JCTypeCast)parent;
            return typeCast.expr == leaf ? 14 : 0;
        }
        if (parent instanceof JCTree.JCInstanceOf) {
            JCTree.JCInstanceOf instanceOf = (JCTree.JCInstanceOf)parent;
            return 10 + (instanceOf.getType() == leaf ? 1 : 0);
        }
        if (parent instanceof JCTree.JCArrayAccess) {
            JCTree.JCArrayAccess arrayAccess = (JCTree.JCArrayAccess)parent;
            return arrayAccess.indexed == leaf ? 15 : 0;
        }
        if (parent instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)parent;
            return fieldAccess.selected == leaf ? 15 : 0;
        }
        return 0;
    }
}

