/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Modifier;

@BugPattern(name="CannotMockFinalClass", summary="Mockito cannot mock final classes", severity=BugPattern.SeverityLevel.WARNING)
public class CannotMockFinalClass
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Matcher<AnnotationTree> runWithJunit4 = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isType((String)"org.junit.runner.RunWith"), Matchers.hasArgumentWithValue((String)"value", (Matcher)Matchers.classLiteral((Matcher)Matchers.isSameType((String)"org.junit.runners.JUnit4")))});
    private static final Matcher<Tree> enclosingClassIsJunit4Test = Matchers.enclosingClass((Matcher)Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, runWithJunit4));
    private static final Matcher<VariableTree> variableOfFinalClassAnnotatedMock = Matchers.allOf((Matcher[])new Matcher[]{Matchers.variableType((Matcher)Matchers.hasModifier((Modifier)Modifier.FINAL)), Matchers.hasAnnotation((String)"org.mockito.Mock"), enclosingClassIsJunit4Test});
    private static final Matcher<MethodInvocationTree> creationOfMockForFinalClass = Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("org.mockito.Mockito").named("mock"), Matchers.argument((int)0, (Matcher)Matchers.classLiteral((Matcher)Matchers.hasModifier((Modifier)Modifier.FINAL))), enclosingClassIsJunit4Test});

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return variableOfFinalClassAnnotatedMock.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return creationOfMockForFinalClass.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

