/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import org.checkerframework.shaded.dataflow.analysis.AbstractValue;

public enum Nullness implements AbstractValue<Nullness>
{
    NULLABLE("Nullable"),
    NULL("Null"),
    NONNULL("Non-null"),
    BOTTOM("Bottom");

    private final String displayName;

    private Nullness(String displayName) {
        this.displayName = displayName;
    }

    public Nullness leastUpperBound(Nullness other) {
        if (this == other) {
            return this;
        }
        if (this == BOTTOM) {
            return other;
        }
        if (other == BOTTOM) {
            return this;
        }
        return NULLABLE;
    }

    public Nullness greatestLowerBound(Nullness other) {
        if (this == other) {
            return this;
        }
        if (this == NULLABLE) {
            return other;
        }
        if (other == NULLABLE) {
            return this;
        }
        return BOTTOM;
    }

    public Nullness deducedValueWhenNotEqual() {
        switch (this) {
            case NULLABLE: 
            case NONNULL: {
                return NULLABLE;
            }
            case NULL: {
                return NONNULL;
            }
            case BOTTOM: {
                return BOTTOM;
            }
        }
        throw new AssertionError((Object)("Inverse of " + (Object)((Object)this) + " not defined"));
    }

    public String toString() {
        return this.displayName;
    }
}

