/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.base.Predicate;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_TypeCompatibilityUtils_TypeCompatibilityReport;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class TypeCompatibilityUtils {
    public static TypeCompatibilityReport compatibilityOfTypes(Type receiverType, Type argumentType, VisitorState state) {
        return TypeCompatibilityUtils.compatibilityOfTypes(receiverType, argumentType, TypeCompatibilityUtils.typeSet(state), TypeCompatibilityUtils.typeSet(state), state);
    }

    private static TypeCompatibilityReport compatibilityOfTypes(Type receiverType, Type argumentType, Set<Type> previousReceiverTypes, Set<Type> previousArgumentTypes, VisitorState state) {
        if (receiverType == null || argumentType == null) {
            return TypeCompatibilityReport.createCompatibleReport();
        }
        if (receiverType.isPrimitive() && argumentType.isPrimitive() && !ASTHelpers.isSameType((Type)receiverType, (Type)argumentType, (VisitorState)state)) {
            return TypeCompatibilityReport.incompatible(receiverType, argumentType);
        }
        if (ASTHelpers.isCastable((Type)argumentType, (Type)receiverType, (VisitorState)state)) {
            return TypeCompatibilityUtils.leastUpperBoundGenericMismatch(receiverType, argumentType, previousReceiverTypes, previousArgumentTypes, state);
        }
        Types types = state.getTypes();
        Predicate equalsPredicate = methodSymbol -> !methodSymbol.isStatic() && (methodSymbol.flags() & 0x1000L) == 0L && types.isSameType(methodSymbol.getReturnType(), state.getSymtab().booleanType) && ((List)methodSymbol.getParameters()).size() == 1 && types.isSameType(((Symbol.VarSymbol)((List)methodSymbol.getParameters()).get((int)0)).type, state.getSymtab().objectType);
        Set overridesOfEquals = ASTHelpers.findMatchingMethods((Name)state.getName("equals"), (Predicate)equalsPredicate, (Type)receiverType, (Types)types);
        Symbol.TypeSymbol argumentClass = ASTHelpers.getUpperBound((Type)argumentType, (Types)state.getTypes()).tsym;
        for (Symbol.MethodSymbol method : overridesOfEquals) {
            Symbol.ClassSymbol methodClass = method.enclClass();
            if (!argumentClass.isSubClass(methodClass, types) || methodClass.equals(state.getSymtab().objectType.tsym) || methodClass.equals(state.getSymtab().enumSym)) continue;
            return TypeCompatibilityUtils.leastUpperBoundGenericMismatch(receiverType, argumentType, previousReceiverTypes, previousArgumentTypes, state);
        }
        return TypeCompatibilityReport.incompatible(receiverType, argumentType);
    }

    private static TypeCompatibilityReport leastUpperBoundGenericMismatch(Type receiverType, Type argumentType, Set<Type> previousReceiverTypes, Set<Type> previousArgumentTypes, VisitorState state) {
        Type lub = state.getTypes().lub(argumentType, receiverType);
        if (lub.getTag().equals((Object)TypeTag.BOT) || lub.getTag().equals((Object)TypeTag.ERROR)) {
            return TypeCompatibilityReport.createCompatibleReport();
        }
        TypeCompatibilityReport compatibilityReport = TypeCompatibilityUtils.matchesSubtypeAndIsGenericMismatch(receiverType, argumentType, lub, previousReceiverTypes, previousArgumentTypes, state);
        if (!compatibilityReport.compatible()) {
            return compatibilityReport;
        }
        Type collectionType = state.getTypeFromString("java.util.Collection");
        if (ASTHelpers.isSameType((Type)lub, (Type)collectionType, (VisitorState)state) && !ASTHelpers.isSameType((Type)receiverType, (Type)collectionType, (VisitorState)state) && !ASTHelpers.isSameType((Type)argumentType, (Type)collectionType, (VisitorState)state)) {
            return TypeCompatibilityReport.incompatible(receiverType, argumentType);
        }
        return compatibilityReport;
    }

    private static TypeCompatibilityReport matchesSubtypeAndIsGenericMismatch(Type receiverType, Type argumentType, Type superType, Set<Type> previousReceiverTypes, Set<Type> previousArgumentTypes, VisitorState state) {
        java.util.List<Type> receiverTypes = TypeCompatibilityUtils.typeArgsAsSuper(receiverType, superType, state);
        java.util.List<Type> argumentTypes = TypeCompatibilityUtils.typeArgsAsSuper(argumentType, superType, state);
        return Streams.zip(receiverTypes.stream(), argumentTypes.stream(), TypePair::new).filter(tp -> !previousReceiverTypes.contains(tp.receiver) && !ASTHelpers.isSameType((Type)tp.receiver, (Type)receiverType, (VisitorState)state) && !previousArgumentTypes.contains(tp.argument) && !ASTHelpers.isSameType((Type)tp.argument, (Type)argumentType, (VisitorState)state)).map(types -> {
            TreeSet<Type> nextReceiverTypes = TypeCompatibilityUtils.typeSet(state);
            nextReceiverTypes.addAll(previousReceiverTypes);
            nextReceiverTypes.add(receiverType);
            TreeSet<Type> nextArgumentTypes = TypeCompatibilityUtils.typeSet(state);
            nextArgumentTypes.addAll(previousArgumentTypes);
            nextArgumentTypes.add(argumentType);
            return TypeCompatibilityUtils.compatibilityOfTypes(types.receiver, types.argument, nextReceiverTypes, nextArgumentTypes, state);
        }).filter(tcr -> !tcr.compatible()).findFirst().orElse(TypeCompatibilityReport.createCompatibleReport());
    }

    private static java.util.List<Type> typeArgsAsSuper(Type baseType, Type superType, VisitorState state) {
        Type projectedType = state.getTypes().asSuper(baseType, superType.tsym);
        if (projectedType != null) {
            return projectedType.getTypeArguments();
        }
        return new ArrayList<Type>();
    }

    private static TreeSet<Type> typeSet(VisitorState state) {
        return new TreeSet<Type>((t1, t2) -> state.getTypes().isSameType((Type)t1, (Type)t2) ? 0 : t1.toString().compareTo(t2.toString()));
    }

    private static final class TypePair {
        final Type receiver;
        final Type argument;

        TypePair(Type receiver, Type argument) {
            this.receiver = receiver;
            this.argument = argument;
        }
    }

    @AutoValue
    public static abstract class TypeCompatibilityReport {
        public abstract boolean compatible();

        @Nullable
        public abstract Type lhs();

        @Nullable
        public abstract Type rhs();

        static TypeCompatibilityReport createCompatibleReport() {
            return new AutoValue_TypeCompatibilityUtils_TypeCompatibilityReport(true, null, null);
        }

        static TypeCompatibilityReport incompatible(Type lhs, Type rhs) {
            return new AutoValue_TypeCompatibilityUtils_TypeCompatibilityReport(false, lhs, rhs);
        }
    }
}

