/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.TrustingNullnessAnalysis;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;

@BugPattern(name="ParameterNotNullable", summary="Method parameters that aren't checked for null shouldn't be annotated @Nullable", severity=BugPattern.SeverityLevel.SUGGESTION)
public class ParameterNotNullable
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher,
BugChecker.ArrayAccessTreeMatcher {
    public Description matchArrayAccess(ArrayAccessTree tree, VisitorState state) {
        return this.matchDereference(tree.getExpression(), state);
    }

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        return this.matchDereference(tree.getExpression(), state);
    }

    private Description matchDereference(ExpressionTree dereferencedExpression, VisitorState state) {
        Symbol dereferenced = ASTHelpers.getSymbol((Tree)dereferencedExpression);
        if (dereferenced == null || dereferenced.getKind() != ElementKind.PARAMETER || dereferenced.type.isPrimitive()) {
            return Description.NO_MATCH;
        }
        if (!TrustingNullnessAnalysis.hasNullableAnnotation((Symbol)dereferenced)) {
            return Description.NO_MATCH;
        }
        Nullness nullness = TrustingNullnessAnalysis.instance((Context)state.context).getNullness(new TreePath(state.getPath(), dereferencedExpression), state.context);
        if (nullness != Nullness.NULLABLE) {
            return Description.NO_MATCH;
        }
        VariableTree paramDecl = this.findDeclaration(state, dereferenced);
        for (AnnotationTree annotationTree : paramDecl.getModifiers().getAnnotations()) {
            String annoType = ASTHelpers.getSymbol((Tree)annotationTree).type.toString();
            if (!annoType.endsWith(".Nullable") && !annoType.endsWith(".NullableDecl") && !annoType.endsWith(".CheckForNull") && !annoType.endsWith(".RecentlyNullable")) continue;
            return this.buildDescription(dereferencedExpression).setMessage("Nullable parameter not checked for null").addFix((Fix)SuggestedFix.delete((Tree)annotationTree)).build();
        }
        if (paramDecl.getType() instanceof AnnotatedTypeTree) {
            for (AnnotationTree annotationTree : ((AnnotatedTypeTree)paramDecl.getType()).getAnnotations()) {
                if (!ASTHelpers.getSymbol((Tree)annotationTree).type.toString().endsWith(".Nullable")) continue;
                return this.buildDescription(dereferencedExpression).setMessage("Nullable parameter not checked for null").addFix((Fix)SuggestedFix.delete((Tree)annotationTree)).build();
            }
        }
        return Description.NO_MATCH;
    }

    @Nullable
    private VariableTree findDeclaration(VisitorState state, Symbol parameter) {
        JavacProcessingEnvironment javacEnv = JavacProcessingEnvironment.instance(state.context);
        TreePath declPath = Trees.instance(javacEnv).getPath(parameter);
        if (declPath != null && declPath.getCompilationUnit() == state.getPath().getCompilationUnit() && declPath.getLeaf() instanceof VariableTree) {
            return (VariableTree)declPath.getLeaf();
        }
        return null;
    }
}

