/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;

@BugPattern(name="JMockTestWithoutRunWithOrRuleAnnotation", summary="jMock tests must have a @RunWith(JMock.class) annotation, or the Mockery field must have a @Rule JUnit annotation", severity=BugPattern.SeverityLevel.ERROR)
public class JMockTestWithoutRunWithOrRuleAnnotation
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final String JMOCK_TEST_RUNNER_CLASS = "org.jmock.integration.junit4.JMock";
    private static final Matcher<VariableTree> fieldIsMockery = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isSubtypeOf((String)"org.jmock.Mockery"), Matchers.isField()});
    private static final Matcher<VariableTree> fieldHasRuleAnnotation = Matchers.hasAnnotation((String)"org.junit.Rule");
    private static final Matcher<Tree> enclosingClassRunsWithJMockTestRunner = Matchers.enclosingClass((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasAnnotation((String)"org.junit.runner.RunWith"), Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.hasArgumentWithValue((String)"value", (Matcher)Matchers.classLiteral((Matcher)Matchers.isSameType((String)"org.jmock.integration.junit4.JMock"))))}));
    private static final Matcher<VariableTree> BUG_PATTERN_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{fieldIsMockery, Matchers.not((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{fieldHasRuleAnnotation, enclosingClassRunsWithJMockTestRunner}))});

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (BUG_PATTERN_MATCHER.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

