/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.JavaContext;
import java.util.ListIterator;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.Cast;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.InlineIfExpression;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.Select;
import lombok.ast.Statement;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;

public class PermissionFinder {
    private final JavaContext mContext;
    private final Operation mOperation;

    public static Result findRequiredPermissions(Operation operation, JavaContext context, Node parameter) {
        return new PermissionFinder(context, operation).search(parameter);
    }

    private PermissionFinder(JavaContext context, Operation operation) {
        this.mContext = context;
        this.mOperation = operation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result search(Node node) {
        Statement statement;
        if (node instanceof NullLiteral) {
            return null;
        }
        if (node instanceof InlineIfExpression) {
            Result result;
            InlineIfExpression expression = (InlineIfExpression)node;
            if (expression.astIfTrue() != null && (result = this.search((Node)expression.astIfTrue())) != null) {
                return result;
            }
            if (expression.astIfFalse() == null || (result = this.search((Node)expression.astIfFalse())) == null) return null;
            return result;
        }
        if (node instanceof Cast) {
            Cast cast = (Cast)node;
            return this.search((Node)cast.astOperand());
        }
        if (node instanceof ConstructorInvocation && this.mOperation == Operation.ACTION) {
            Expression action;
            ConstructorInvocation call = (ConstructorInvocation)node;
            String type = call.astTypeReference().getTypeName();
            if (!type.equals("Intent") && !type.equals("android.content.Intent") || (action = (Expression)call.astArguments().first()) == null) return null;
            return this.search((Node)action);
        }
        if (!(node instanceof VariableReference) && !(node instanceof Select)) return null;
        JavaParser.ResolvedNode resolved = this.mContext.resolve(node);
        if (resolved instanceof JavaParser.ResolvedField) {
            JavaParser.ResolvedField field = (JavaParser.ResolvedField)resolved;
            if (this.mOperation == Operation.ACTION) {
                JavaParser.ResolvedAnnotation annotation = field.getAnnotation("android.support.annotation.RequiresPermission");
                if (annotation == null) return null;
                return this.getPermissionRequirement(field, annotation);
            }
            if (this.mOperation == Operation.READ || this.mOperation == Operation.WRITE) {
                String fqn = this.mOperation == Operation.READ ? "android.support.annotation.RequiresPermission.Read" : "android.support.annotation.RequiresPermission.Write";
                JavaParser.ResolvedAnnotation annotation = field.getAnnotation(fqn);
                if (annotation == null) return null;
                Object o = annotation.getValue();
                if (!(o instanceof JavaParser.ResolvedAnnotation)) return this.getPermissionRequirement(field, annotation);
                annotation = (JavaParser.ResolvedAnnotation)o;
                if (!annotation.matches("android.support.annotation.RequiresPermission")) return null;
                return this.getPermissionRequirement(field, annotation);
            }
            assert (false) : this.mOperation;
            return null;
        }
        if (!(node instanceof VariableReference) || (statement = (Statement)JavaContext.getParentOfType((Node)node, Statement.class, (boolean)false)) == null) return null;
        ListIterator iterator = statement.getParent().getChildren().listIterator();
        while (iterator.hasNext()) {
            if (iterator.next() != statement) continue;
            if (!iterator.hasPrevious()) break;
            iterator.previous();
            break;
        }
        String targetName = ((VariableReference)node).astIdentifier().astValue();
        while (iterator.hasPrevious()) {
            BinaryExpression binaryExpression;
            ExpressionStatement expressionStatement;
            Expression expression;
            Node previous = (Node)iterator.previous();
            if (previous instanceof VariableDeclaration) {
                VariableDeclaration declaration = (VariableDeclaration)previous;
                VariableDefinition definition = declaration.astDefinition();
                for (VariableDefinitionEntry entry : definition.astVariables()) {
                    if (entry.astInitializer() == null || !entry.astName().astValue().equals(targetName)) continue;
                    return this.search((Node)entry.astInitializer());
                }
                continue;
            }
            if (!(previous instanceof ExpressionStatement) || !((expression = (expressionStatement = (ExpressionStatement)previous).astExpression()) instanceof BinaryExpression) || ((BinaryExpression)expression).astOperator() != BinaryOperator.ASSIGN || !targetName.equals((binaryExpression = (BinaryExpression)expression).astLeft().toString())) continue;
            return this.search((Node)binaryExpression.astRight());
        }
        return null;
    }

    private Result getPermissionRequirement(JavaParser.ResolvedField field, JavaParser.ResolvedAnnotation annotation) {
        PermissionRequirement requirement = PermissionRequirement.create((Context)this.mContext, annotation);
        JavaParser.ResolvedClass containingClass = field.getContainingClass();
        String name = containingClass != null ? containingClass.getSimpleName() + "." + field.getName() : field.getName();
        return new Result(this.mOperation, requirement, name);
    }

    public static class Result {
        public final PermissionRequirement requirement;
        public final String name;
        public final Operation operation;

        public Result(Operation operation, PermissionRequirement requirement, String name) {
            this.operation = operation;
            this.requirement = requirement;
            this.name = name;
        }
    }

    public static enum Operation {
        CALL,
        ACTION,
        READ,
        WRITE;


        public String prefix() {
            switch (this) {
                case ACTION: {
                    return "by intent";
                }
                case READ: {
                    return "to read";
                }
                case WRITE: {
                    return "to write";
                }
            }
            return "by";
        }
    }
}

