/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.concurrent.UnlockMethod;
import com.google.errorprone.bugpatterns.threadsafety.AbstractLockMethodChecker;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByExpression;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByFlags;
import com.google.errorprone.bugpatterns.threadsafety.HeldLockAnalyzer;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.Set;

@BugPattern(name="UnlockMethod", altNames={"GuardedBy"}, summary="This method does not acquire the locks specified by its @UnlockMethod annotation", severity=BugPattern.SeverityLevel.ERROR)
public class UnlockMethodChecker
extends AbstractLockMethodChecker {
    @Override
    protected ImmutableList<String> getLockExpressions(MethodTree tree) {
        UnlockMethod unlockMethod = (UnlockMethod)ASTHelpers.getAnnotation((Tree)tree, UnlockMethod.class);
        return unlockMethod == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])unlockMethod.value());
    }

    @Override
    protected Set<GuardedByExpression> getActual(MethodTree tree, VisitorState state) {
        return ImmutableSet.copyOf(HeldLockAnalyzer.ReleasedLockFinder.find(tree.getBody(), state, GuardedByFlags.allOn()));
    }

    @Override
    protected Set<GuardedByExpression> getUnwanted(MethodTree tree, VisitorState state) {
        return ImmutableSet.copyOf(HeldLockAnalyzer.AcquiredLockFinder.find(tree.getBody(), state, GuardedByFlags.allOn()));
    }

    @Override
    protected String buildMessage(String unhandled) {
        return "The following locks are specified by this method's @UnlockMethod anotation but are not released: " + unhandled;
    }
}

