/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.JavadocTag;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@BugPattern(name="InvalidInlineTag", summary="This tag is invalid.", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"}, documentSuppression=false)
public final class InvalidInlineTag
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final String INVALID_TAG_IS_PARAMETER_NAME = "@%1$s is not a valid tag, but is a parameter name. Use {@code %1%s} to refer to parameter names inline.";
    private static final Pattern PARAM_MATCHER = Pattern.compile("\\{?@param ([a-zA-Z0-9]+)}?");
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');

    public Description matchClass(ClassTree classTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            ImmutableSet parameters = ImmutableSet.of();
            new InvalidTagChecker(state, JavadocTag.VALID_CLASS_TAGS, parameters).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            ImmutableSet parameters = (ImmutableSet)methodTree.getParameters().stream().map(v -> v.getName().toString()).collect(ImmutableSet.toImmutableSet());
            new InvalidTagChecker(state, JavadocTag.VALID_METHOD_TAGS, parameters).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            new InvalidTagChecker(state, JavadocTag.VALID_VARIABLE_TAGS, ImmutableSet.of()).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    private final class InvalidTagChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;
        private final ImmutableSet<JavadocTag> validTags;
        private final ImmutableSet<String> parameters;
        private final Pattern misplacedCurly;
        private final Pattern parensRatherThanCurly;
        private final Set<DocTree> fixedTags = new HashSet<DocTree>();

        private InvalidTagChecker(VisitorState state, ImmutableSet<JavadocTag> validTags, ImmutableSet<String> parameters) {
            this.state = state;
            this.validTags = validTags;
            this.parameters = parameters;
            String validInlineTags = validTags.stream().filter(tag -> tag.type() == JavadocTag.TagType.INLINE).map(JavadocTag::name).collect(Collectors.joining("|"));
            this.misplacedCurly = Pattern.compile(String.format("@(%s)\\{", validInlineTags));
            this.parensRatherThanCurly = Pattern.compile(String.format("\\(@(%s)", validInlineTags));
        }

        @Override
        public Void visitErroneous(ErroneousTree erroneousTree, Void unused) {
            String parameterName;
            Matcher matcher = PARAM_MATCHER.matcher(erroneousTree.getBody());
            if (matcher.find() && this.parameters.contains((Object)(parameterName = matcher.group(1)))) {
                String message = String.format("@param cannot be used inline to refer to parameters; {@code %s} is recommended", parameterName);
                this.state.reportMatch(InvalidInlineTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)Utils.replace(erroneousTree, String.format("{@code %s}", parameterName), this.state)).build());
            }
            return null;
        }

        @Override
        public Void visitText(TextTree node, Void unused) {
            this.handleMalformedTags(node);
            this.handleIncorrectParens(node);
            this.handleDanglingParams(node);
            return (Void)super.visitText(node, null);
        }

        private void handleMalformedTags(TextTree node) {
            String body = node.getBody();
            Matcher matcher = this.misplacedCurly.matcher(body);
            Tokens.Comment comment = ((DCTree.DCDocComment)this.getCurrentPath().getDocComment()).comment;
            while (matcher.find()) {
                int beforeAt = comment.getSourcePos(((DCTree.DCText)node).pos + matcher.start());
                int startOfCurly = comment.getSourcePos(((DCTree.DCText)node).pos + matcher.end(1));
                SuggestedFix fix = SuggestedFix.builder().replace(beforeAt, beforeAt, "{").replace(startOfCurly, startOfCurly + 1, " ").build();
                this.state.reportMatch(InvalidInlineTag.this.describeMatch(Utils.getDiagnosticPosition(beforeAt, this.getCurrentPath().getTreePath().getLeaf()), (Fix)fix));
            }
        }

        private void handleIncorrectParens(TextTree node) {
            String body = node.getBody();
            Matcher matcher = this.parensRatherThanCurly.matcher(body);
            Tokens.Comment comment = ((DCTree.DCDocComment)this.getCurrentPath().getDocComment()).comment;
            while (matcher.find()) {
                int beforeAt = comment.getSourcePos(((DCTree.DCText)node).pos + matcher.start());
                SuggestedFix.Builder fix = SuggestedFix.builder().replace(beforeAt, beforeAt + 1, "{");
                Optional<Integer> found = this.findClosingBrace(body, matcher.start(1));
                found.ifPresent(pos -> {
                    int closing = comment.getSourcePos(((DCTree.DCText)node).pos + pos);
                    fix.replace(closing, closing + 1, "}");
                });
                this.state.reportMatch(InvalidInlineTag.this.buildDescription(Utils.getDiagnosticPosition(beforeAt, this.getCurrentPath().getTreePath().getLeaf())).setMessage(String.format("Curly braces should be used for inline Javadoc tags: {@%s ...}", matcher.group(1))).addFix((Fix)fix.build()).build());
            }
        }

        private Optional<Integer> findClosingBrace(String body, int startPos) {
            int parenDepth = 0;
            block5: for (int pos = startPos; pos < body.length(); ++pos) {
                char c = body.charAt(pos);
                switch (c) {
                    case '(': {
                        ++parenDepth;
                        continue block5;
                    }
                    case ')': {
                        if (parenDepth == 0) {
                            return Optional.of(pos);
                        }
                        --parenDepth;
                        continue block5;
                    }
                    case '}': {
                        return Optional.empty();
                    }
                }
            }
            return Optional.empty();
        }

        private void handleDanglingParams(TextTree node) {
            Matcher matcher = PARAM_MATCHER.matcher(node.getBody());
            Tokens.Comment comment = ((DCTree.DCDocComment)this.getCurrentPath().getDocComment()).comment;
            while (matcher.find()) {
                int startPos = comment.getSourcePos(((DCTree.DCText)node).pos + matcher.start());
                int endPos = comment.getSourcePos(((DCTree.DCText)node).pos + matcher.end());
                String paramName = matcher.group(1);
                SuggestedFix fix = SuggestedFix.replace((int)startPos, (int)endPos, (String)String.format("{@code %s}", paramName));
                this.state.reportMatch(InvalidInlineTag.this.describeMatch(Utils.getDiagnosticPosition(startPos, this.getCurrentPath().getTreePath().getLeaf()), (Fix)fix));
            }
        }

        @Override
        public Void visitUnknownInlineTag(UnknownInlineTagTree unknownInlineTagTree, Void unused) {
            String name = unknownInlineTagTree.getTagName();
            if (this.parameters.contains((Object)name)) {
                String message = String.format(InvalidInlineTag.INVALID_TAG_IS_PARAMETER_NAME, name);
                this.state.reportMatch(InvalidInlineTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)Utils.replace(unknownInlineTagTree, String.format("{@code %s}", name), this.state)).build());
                this.fixedTags.add(unknownInlineTagTree);
                return (Void)super.visitUnknownInlineTag(unknownInlineTagTree, null);
            }
            if (this.isProbablyType(name)) {
                int startPos = Utils.getStartPosition(unknownInlineTagTree, this.state);
                String message = String.format("The tag {@%1$s} is not valid, and will not display or cross-link to the type %1$s correctly. Prefer {@link %1$s}.", name);
                this.state.reportMatch(InvalidInlineTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)SuggestedFix.replace((int)startPos, (int)(startPos + 2), (String)"{@link ")).build());
                this.fixedTags.add(unknownInlineTagTree);
                return (Void)super.visitUnknownInlineTag(unknownInlineTagTree, null);
            }
            this.reportUnknownTag(unknownInlineTagTree, JavadocTag.inlineTag(name));
            return (Void)super.visitUnknownInlineTag(unknownInlineTagTree, null);
        }

        private boolean isProbablyType(String name) {
            Symbol typeSymbol = FindIdentifiers.findIdent((String)((String)Iterables.getFirst((Iterable)DOT_SPLITTER.split((CharSequence)name), null)), (VisitorState)this.state, (Kinds.KindSelector)Kinds.KindSelector.TYP);
            return typeSymbol instanceof Symbol.TypeSymbol || name.chars().filter(c -> c == 46).count() >= 3L || name.contains("#");
        }

        private void reportUnknownTag(DocTree docTree, JavadocTag tag) {
            Optional<String> bestMatch = Utils.getBestMatch(tag.name(), (Iterable)this.validTags.stream().filter(t -> t.type().equals((Object)tag.type())).map(JavadocTag::name).collect(ImmutableSet.toImmutableSet()));
            int pos = Utils.getStartPosition(docTree, this.state) + docTree.toString().indexOf(tag.name());
            String message = String.format("Tag name `%s` is unknown.", tag.name());
            this.state.reportMatch(bestMatch.map(bm -> InvalidInlineTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message + String.format(" Did you mean tag `%s`?", bm)).addFix((Fix)SuggestedFix.replace((int)pos, (int)(pos + tag.name().length()), (String)bm)).build()).orElse(InvalidInlineTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message + " If this is a commonly-used custom tag, please click 'not useful' and file a bug.").build()));
            this.fixedTags.add(docTree);
        }

        @Override
        public Void scan(DocTree docTree, Void unused) {
            super.scan(docTree, null);
            if (this.fixedTags.contains(docTree)) {
                return null;
            }
            if (!(docTree instanceof DCTree.DCInlineTag)) {
                return null;
            }
            JavadocTag tag = JavadocTag.inlineTag(((DCTree.DCInlineTag)docTree).getTagName());
            if (this.validTags.contains((Object)tag) || JavadocTag.KNOWN_OTHER_TAGS.contains((Object)tag)) {
                return null;
            }
            String message = String.format("The tag @%s is not allowed on this type of element.", tag.name());
            this.state.reportMatch(InvalidInlineTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)Utils.replace(docTree, "", this.state)).build());
            return null;
        }
    }
}

