/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.tools.javac.code.Type;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.type.TypeKind;

@BugPattern(name="RandomCast", summary="Casting a random number in the range [0.0, 1.0) to an integer or long always results in 0.", severity=BugPattern.SeverityLevel.ERROR)
public class RandomCast
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onExactClass("java.util.Random").namedAnyOf(new String[]{"nextFloat", "nextDouble"}), Matchers.staticMethod().onClass("java.lang.Math").named("random")});
    private static final Set<TypeKind> INTEGRAL = EnumSet.of(TypeKind.LONG, TypeKind.INT);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof TypeCastTree)) {
            return Description.NO_MATCH;
        }
        if (!((TypeCastTree)parent).getExpression().equals(tree)) {
            return Description.NO_MATCH;
        }
        Type type = ASTHelpers.getType((Tree)parent);
        if (type == null || !INTEGRAL.contains((Object)type.getKind())) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

