/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers.method;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.method.BaseMethodMatcher;
import com.google.errorprone.matchers.method.MatchState;
import com.google.errorprone.matchers.method.MethodInvocationMatcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

final class MethodMatcherImpl
implements MethodMatchers.MethodMatcher,
MethodMatchers.InstanceMethodMatcher,
MethodMatchers.StaticMethodMatcher,
MethodMatchers.AnyMethodMatcher,
MethodMatchers.MethodClassMatcher,
MethodMatchers.MethodSignatureMatcher,
MethodMatchers.MethodNameMatcher,
MethodMatchers.ConstructorMatcher,
MethodMatchers.ConstructorClassMatcher,
MethodMatchers.ParameterMatcher {
    static final MethodMatchers.AnyMethodMatcher ANY_METHOD = new MethodMatcherImpl(BaseMethodMatcher.METHOD, (ImmutableList<Constraint>)ImmutableList.of((Object)new Constraint(){

        @Override
        public boolean matches(MatchState m, VisitorState s) {
            return true;
        }

        @Override
        public Optional<RulePart> asRulePart() {
            return RulePart.of(MethodInvocationMatcher.TokenType.KIND, (ImmutableSet<MethodInvocationMatcher.Token>)ImmutableSet.of((Object)MethodInvocationMatcher.Token.Kind.create(MethodInvocationMatcher.MethodKind.INSTANCE), (Object)MethodInvocationMatcher.Token.Kind.create(MethodInvocationMatcher.MethodKind.STATIC)));
        }
    }));
    static final MethodMatchers.ConstructorMatcher CONSTRUCTOR = new MethodMatcherImpl(BaseMethodMatcher.CONSTRUCTOR, (ImmutableList<Constraint>)ImmutableList.of((Object)new Constraint(){

        @Override
        public boolean matches(MatchState m, VisitorState s) {
            return true;
        }

        @Override
        public Optional<RulePart> asRulePart() {
            return RulePart.of(MethodInvocationMatcher.TokenType.KIND, (ImmutableSet<MethodInvocationMatcher.Token>)ImmutableSet.of((Object)MethodInvocationMatcher.Token.Kind.create(MethodInvocationMatcher.MethodKind.CONSTRUCTOR)));
        }
    }));
    static final MethodMatchers.StaticMethodMatcher STATIC_METHOD = new MethodMatcherImpl(BaseMethodMatcher.METHOD, (ImmutableList<Constraint>)ImmutableList.of((Object)new Constraint(){

        @Override
        public boolean matches(MatchState m, VisitorState s) {
            return m.sym().isStatic();
        }

        @Override
        public Optional<RulePart> asRulePart() {
            return RulePart.of(MethodInvocationMatcher.TokenType.KIND, (ImmutableSet<MethodInvocationMatcher.Token>)ImmutableSet.of((Object)MethodInvocationMatcher.Token.Kind.create(MethodInvocationMatcher.MethodKind.STATIC)));
        }
    }));
    static final MethodMatchers.InstanceMethodMatcher INSTANCE_METHOD = new MethodMatcherImpl(BaseMethodMatcher.METHOD, (ImmutableList<Constraint>)ImmutableList.of((Object)new Constraint(){

        @Override
        public boolean matches(MatchState m, VisitorState s) {
            return !m.sym().isStatic();
        }

        @Override
        public Optional<RulePart> asRulePart() {
            return RulePart.of(MethodInvocationMatcher.TokenType.KIND, (ImmutableSet<MethodInvocationMatcher.Token>)ImmutableSet.of((Object)MethodInvocationMatcher.Token.Kind.create(MethodInvocationMatcher.MethodKind.INSTANCE)));
        }
    }));
    private final BaseMethodMatcher baseMatcher;
    private final ImmutableList<Constraint> constraints;

    private MethodMatcherImpl(BaseMethodMatcher baseMatcher, ImmutableList<Constraint> matchers) {
        this.baseMatcher = baseMatcher;
        this.constraints = matchers;
    }

    private MethodMatcherImpl append(Constraint c) {
        return new MethodMatcherImpl(this.baseMatcher, (ImmutableList<Constraint>)ImmutableList.builder().addAll(this.constraints).add((Object)c).build());
    }

    @Override
    public boolean matches(ExpressionTree tree, VisitorState state) {
        MatchState method = this.baseMatcher.match(tree);
        if (method == null) {
            return false;
        }
        for (Constraint constraint : this.constraints) {
            if (constraint.matches(method, state)) continue;
            return false;
        }
        return true;
    }

    @Override
    public MethodMatchers.MethodClassMatcher onClass(final TypePredicate predicate) {
        return this.append(new OpaqueConstraint(){

            @Override
            public boolean matches(MatchState m, VisitorState s) {
                return predicate.apply(m.ownerType(), s);
            }
        });
    }

    @Override
    public MethodMatchers.MethodClassMatcher onClass(final String className) {
        final TypePredicate pred = TypePredicates.isExactType(className);
        return this.append(new Constraint(){

            @Override
            public boolean matches(MatchState m, VisitorState s) {
                return pred.apply(m.ownerType(), s);
            }

            @Override
            public Optional<RulePart> asRulePart() {
                return RulePart.of(MethodInvocationMatcher.TokenType.RECEIVER_TYPE, (ImmutableSet<MethodInvocationMatcher.Token>)ImmutableSet.of((Object)MethodInvocationMatcher.Token.ReceiverType.create(className)));
            }
        });
    }

    @Override
    public MethodMatchers.MethodClassMatcher onClass(Supplier<Type> classType) {
        return this.onClass(TypePredicates.isExactType(classType));
    }

    @Override
    public MethodMatchers.MethodClassMatcher onClassAny(final Iterable<String> classNames) {
        final TypePredicate pred = TypePredicates.isExactTypeAny(classNames);
        return this.append(new Constraint(){

            @Override
            public boolean matches(MatchState m, VisitorState s) {
                return pred.apply(m.ownerType(), s);
            }

            @Override
            public Optional<RulePart> asRulePart() {
                return RulePart.of(MethodInvocationMatcher.TokenType.RECEIVER_TYPE, (ImmutableSet<MethodInvocationMatcher.Token>)((ImmutableSet)Streams.stream((Iterable)classNames).map(MethodInvocationMatcher.Token.ReceiverType::create).collect(ImmutableSet.toImmutableSet())));
            }
        });
    }

    @Override
    public MethodMatchers.MethodClassMatcher onClassAny(String ... classNames) {
        return this.onClassAny((Iterable<String>)ImmutableList.copyOf((Object[])classNames));
    }

    @Override
    public MethodMatchers.MethodClassMatcher onExactClass(String className) {
        return this.onClass(className);
    }

    @Override
    public MethodMatchers.MethodClassMatcher onExactClass(Supplier<Type> classType) {
        return this.onClass(classType);
    }

    @Override
    public MethodMatchers.MethodClassMatcher onDescendantOf(final String className) {
        final TypePredicate pred = TypePredicates.isDescendantOf(className);
        return this.append(new Constraint(){

            @Override
            public boolean matches(MatchState m, VisitorState s) {
                return pred.apply(m.ownerType(), s);
            }

            @Override
            public Optional<RulePart> asRulePart() {
                return RulePart.of(MethodInvocationMatcher.TokenType.RECEIVER_SUPERTYPE, (ImmutableSet<MethodInvocationMatcher.Token>)ImmutableSet.of((Object)MethodInvocationMatcher.Token.ReceiverSupertype.create(className)));
            }
        });
    }

    @Override
    public MethodMatchers.MethodClassMatcher onDescendantOf(Supplier<Type> classType) {
        return this.onClass(TypePredicates.isDescendantOf(classType));
    }

    @Override
    public MethodMatchers.MethodClassMatcher onDescendantOfAny(String ... classTypes) {
        return this.onDescendantOfAny((Iterable<String>)ImmutableList.copyOf((Object[])classTypes));
    }

    @Override
    public MethodMatchers.MethodClassMatcher onDescendantOfAny(final Iterable<String> classTypes) {
        final TypePredicate pred = TypePredicates.isDescendantOfAny(classTypes);
        return this.append(new Constraint(){

            @Override
            public boolean matches(MatchState m, VisitorState s) {
                return pred.apply(m.ownerType(), s);
            }

            @Override
            public Optional<RulePart> asRulePart() {
                return RulePart.of(MethodInvocationMatcher.TokenType.RECEIVER_SUPERTYPE, (ImmutableSet<MethodInvocationMatcher.Token>)((ImmutableSet)Streams.stream((Iterable)classTypes).map(MethodInvocationMatcher.Token.ReceiverSupertype::create).collect(ImmutableSet.toImmutableSet())));
            }
        });
    }

    @Override
    public MethodMatchers.MethodClassMatcher anyClass() {
        return this;
    }

    @Override
    public MethodMatchers.MethodNameMatcher named(final String name) {
        Preconditions.checkArgument((!name.contains("(") && !name.contains(")") ? 1 : 0) != 0, (String)"method name (%s) cannot contain parentheses; use \"foo\" instead of \"foo()\"", (Object)name);
        return this.append(new Constraint(){

            @Override
            public boolean matches(MatchState m, VisitorState s) {
                return ((Name)m.sym().getSimpleName()).contentEquals(name);
            }

            @Override
            public Optional<RulePart> asRulePart() {
                return RulePart.of(MethodInvocationMatcher.TokenType.METHOD_NAME, (ImmutableSet<MethodInvocationMatcher.Token>)ImmutableSet.of((Object)MethodInvocationMatcher.Token.MethodName.create(name)));
            }
        });
    }

    @Override
    public MethodMatchers.MethodNameMatcher namedAnyOf(String ... names) {
        return this.namedAnyOf((Iterable<String>)ImmutableSet.copyOf((Object[])names));
    }

    @Override
    public MethodMatchers.MethodNameMatcher namedAnyOf(Iterable<String> names) {
        ImmutableSet expected = ImmutableSet.copyOf(names);
        return this.append(new Constraint((Set)expected, names){
            final /* synthetic */ Set val$expected;
            final /* synthetic */ Iterable val$names;
            {
                this.val$expected = set;
                this.val$names = iterable;
            }

            @Override
            public boolean matches(MatchState m, VisitorState s) {
                return this.val$expected.contains(((Name)m.sym().getSimpleName()).toString());
            }

            @Override
            public Optional<RulePart> asRulePart() {
                return RulePart.of(MethodInvocationMatcher.TokenType.METHOD_NAME, (ImmutableSet<MethodInvocationMatcher.Token>)((ImmutableSet)Streams.stream((Iterable)this.val$names).map(MethodInvocationMatcher.Token.MethodName::create).collect(ImmutableSet.toImmutableSet())));
            }
        });
    }

    @Override
    public MethodMatchers.MethodNameMatcher withAnyName() {
        return this;
    }

    @Override
    public MethodMatchers.MethodNameMatcher withNameMatching(final Pattern pattern) {
        return this.append(new OpaqueConstraint(){

            @Override
            public boolean matches(MatchState m, VisitorState s) {
                return pattern.matcher(((Name)m.sym().getSimpleName()).toString()).matches();
            }
        });
    }

    @Override
    public MethodMatchers.MethodSignatureMatcher withSignature(final String signature) {
        return this.append(new OpaqueConstraint(){

            @Override
            public boolean matches(MatchState m, VisitorState s) {
                return ((Name)m.sym().getSimpleName()).contentEquals(signature) || m.sym().toString().equals(signature);
            }
        });
    }

    @Override
    public MethodMatchers.ParameterMatcher withParameters(String ... parameters) {
        return this.withParameters((Iterable<String>)ImmutableList.copyOf((Object[])parameters));
    }

    private MethodMatchers.ParameterMatcher withParameters(final Iterable<Supplier<Type>> expected, final Optional<MethodInvocationMatcher.Token> newConstraint) {
        return this.append(new Constraint(){

            @Override
            public boolean matches(MatchState method, VisitorState state) {
                List<Type> actual = method.paramTypes();
                if (actual.size() != Iterables.size((Iterable)expected)) {
                    return false;
                }
                Iterator<Type> ax = actual.iterator();
                Iterator bx = expected.iterator();
                while (ax.hasNext()) {
                    if (ASTHelpers.isSameType(ax.next(), (Type)((Supplier)bx.next()).get(state), state)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Optional<RulePart> asRulePart() {
                return newConstraint.map(types -> new RulePart(MethodInvocationMatcher.TokenType.PARAMETER_TYPES, (ImmutableSet<MethodInvocationMatcher.Token>)ImmutableSet.of((Object)types)));
            }
        });
    }

    @Override
    public MethodMatchers.ParameterMatcher withParameters(Iterable<String> expected) {
        return this.withParameters((Iterable<Supplier<Type>>)Suppliers.fromStrings(expected), Optional.of(MethodInvocationMatcher.Token.ParameterTypes.create((ImmutableList<String>)ImmutableList.copyOf(expected))));
    }

    @Override
    public MethodMatchers.ParameterMatcher withParametersOfType(Iterable<Supplier<Type>> expected) {
        return this.withParameters(expected, Optional.empty());
    }

    @Override
    public MethodMatchers.ConstructorClassMatcher forClass(final TypePredicate predicate) {
        return this.append(new OpaqueConstraint(){

            @Override
            public boolean matches(MatchState m, VisitorState s) {
                return predicate.apply(m.ownerType(), s);
            }
        });
    }

    @Override
    public MethodMatchers.ConstructorClassMatcher forClass(final String className) {
        return this.append(new Constraint(){

            @Override
            public boolean matches(MatchState m, VisitorState s) {
                return m.ownerType().asElement().getQualifiedName().contentEquals(className);
            }

            @Override
            public Optional<RulePart> asRulePart() {
                return RulePart.of(MethodInvocationMatcher.TokenType.DEFINED_IN, (ImmutableSet<MethodInvocationMatcher.Token>)ImmutableSet.of((Object)MethodInvocationMatcher.Token.DefinedIn.create(className)));
            }
        });
    }

    @Override
    public MethodMatchers.ConstructorClassMatcher forClass(Supplier<Type> classType) {
        return this.forClass(TypePredicates.isExactType(classType));
    }

    @Override
    public Optional<MethodInvocationMatcher.Rule> asRule() {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)this.constraints.size());
        for (Constraint constraint : this.constraints) {
            Optional<RulePart> optionalPart = constraint.asRulePart();
            if (!optionalPart.isPresent()) {
                return Optional.empty();
            }
            RulePart rulePart = optionalPart.get();
            builder.put((Object)rulePart.type, rulePart.tokensAllowed);
        }
        return Optional.of(MethodInvocationMatcher.Rule.create((ImmutableMap<MethodInvocationMatcher.TokenType, ? extends Set<MethodInvocationMatcher.Token>>)builder.build()));
    }

    private static abstract class OpaqueConstraint
    implements Constraint {
        private OpaqueConstraint() {
        }

        @Override
        public Optional<RulePart> asRulePart() {
            return Optional.empty();
        }
    }

    private static interface Constraint {
        public boolean matches(MatchState var1, VisitorState var2);

        public Optional<RulePart> asRulePart();
    }

    private static final class RulePart {
        public final MethodInvocationMatcher.TokenType type;
        public final ImmutableSet<MethodInvocationMatcher.Token> tokensAllowed;

        static Optional<RulePart> of(MethodInvocationMatcher.TokenType type, ImmutableSet<MethodInvocationMatcher.Token> tokensAllowed) {
            return Optional.of(new RulePart(type, tokensAllowed));
        }

        RulePart(MethodInvocationMatcher.TokenType type, ImmutableSet<MethodInvocationMatcher.Token> tokensAllowed) {
            this.type = type;
            this.tokensAllowed = tokensAllowed;
        }
    }
}

