/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.patch;

import com.github.difflib.algorithm.Change;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeleteDelta;
import com.github.difflib.patch.InsertDelta;
import com.github.difflib.patch.PatchFailedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public final class Patch<T> {
    private final List<AbstractDelta<T>> deltas;

    public Patch() {
        this(10);
    }

    public Patch(int estimatedPatchSize) {
        this.deltas = new ArrayList<AbstractDelta<T>>(estimatedPatchSize);
    }

    public List<T> applyTo(List<T> target) throws PatchFailedException {
        ArrayList<T> result = new ArrayList<T>(target);
        ListIterator<AbstractDelta<T>> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            AbstractDelta<T> delta = it.previous();
            delta.applyTo(result);
        }
        return result;
    }

    public List<T> restore(List<T> target) {
        ArrayList<T> result = new ArrayList<T>(target);
        ListIterator<AbstractDelta<T>> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            AbstractDelta<T> delta = it.previous();
            delta.restore(result);
        }
        return result;
    }

    public void addDelta(AbstractDelta<T> delta) {
        this.deltas.add(delta);
    }

    public List<AbstractDelta<T>> getDeltas() {
        Collections.sort(this.deltas, Comparator.comparing(d -> d.getSource().getPosition()));
        return this.deltas;
    }

    public String toString() {
        return "Patch{deltas=" + this.deltas + '}';
    }

    public static <T> Patch<T> generate(List<T> original, List<T> revised, List<Change> changes) {
        Patch<T> patch = new Patch<T>(changes.size());
        for (Change change : changes) {
            Chunk<T> orgChunk = new Chunk<T>(change.startOriginal, new ArrayList<T>(original.subList(change.startOriginal, change.endOriginal)));
            Chunk<T> revChunk = new Chunk<T>(change.startRevised, new ArrayList<T>(revised.subList(change.startRevised, change.endRevised)));
            switch (change.deltaType) {
                case DELETE: {
                    patch.addDelta(new DeleteDelta<T>(orgChunk, revChunk));
                    break;
                }
                case INSERT: {
                    patch.addDelta(new InsertDelta<T>(orgChunk, revChunk));
                    break;
                }
                case CHANGE: {
                    patch.addDelta(new ChangeDelta<T>(orgChunk, revChunk));
                }
            }
        }
        return patch;
    }
}

