/*
 * Decompiled with CFR 0.152.
 */
package javax.lang.model.element;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.UnknownDirectiveException;

public interface ModuleElement
extends Element,
QualifiedNameable {
    @Override
    public Name getQualifiedName();

    @Override
    public Name getSimpleName();

    @Override
    public List<? extends Element> getEnclosedElements();

    public boolean isOpen();

    public boolean isUnnamed();

    @Override
    public Element getEnclosingElement();

    public List<? extends Directive> getDirectives();

    public static interface UsesDirective
    extends Directive {
        public TypeElement getService();
    }

    public static interface ProvidesDirective
    extends Directive {
        public TypeElement getService();

        public List<? extends TypeElement> getImplementations();
    }

    public static interface OpensDirective
    extends Directive {
        public PackageElement getPackage();

        public List<? extends ModuleElement> getTargetModules();
    }

    public static interface ExportsDirective
    extends Directive {
        public PackageElement getPackage();

        public List<? extends ModuleElement> getTargetModules();
    }

    public static interface RequiresDirective
    extends Directive {
        public boolean isStatic();

        public boolean isTransitive();

        public ModuleElement getDependency();
    }

    public static interface DirectiveVisitor<R, P> {
        default public R visit(Directive directive) {
            return directive.accept(this, null);
        }

        default public R visit(Directive directive, P p) {
            return directive.accept(this, p);
        }

        public R visitRequires(RequiresDirective var1, P var2);

        public R visitExports(ExportsDirective var1, P var2);

        public R visitOpens(OpensDirective var1, P var2);

        public R visitUses(UsesDirective var1, P var2);

        public R visitProvides(ProvidesDirective var1, P var2);

        default public R visitUnknown(Directive directive, P p) {
            throw new UnknownDirectiveException(directive, p);
        }
    }

    public static interface Directive {
        public DirectiveKind getKind();

        public <R, P> R accept(DirectiveVisitor<R, P> var1, P var2);
    }

    public static enum DirectiveKind {
        REQUIRES,
        EXPORTS,
        OPENS,
        USES,
        PROVIDES;

    }
}

