/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.javac.main.Main;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.comp.PooledSjavac;
import com.sun.tools.sjavac.comp.SjavacImpl;
import com.sun.tools.sjavac.server.IdleResetSjavac;
import com.sun.tools.sjavac.server.PortFile;
import com.sun.tools.sjavac.server.PortFileMonitor;
import com.sun.tools.sjavac.server.RequestHandler;
import com.sun.tools.sjavac.server.Sjavac;
import com.sun.tools.sjavac.server.Terminable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;

public class SjavacServer
implements Terminable {
    public static final String LINE_TYPE_RC = "RC";
    private final String portfilename;
    private final int poolsize;
    private final int keepalive;
    private final long myCookie;
    private long totalBuildTime;
    Sjavac sjavac;
    private ServerSocket serverSocket;
    private PortFile portFile;
    private PortFileMonitor portFileMonitor;
    final AtomicBoolean keepAcceptingRequests = new AtomicBoolean();
    private static Map<String, PortFile> allPortFiles;

    public SjavacServer(String settings) throws FileNotFoundException {
        this(Util.extractStringOption("portfile", settings), Util.extractIntOption("poolsize", settings, Runtime.getRuntime().availableProcessors()), Util.extractIntOption("keepalive", settings, 120));
    }

    public SjavacServer(String portfilename, int poolsize, int keepalive) throws FileNotFoundException {
        this.portfilename = portfilename;
        this.poolsize = poolsize;
        this.keepalive = keepalive;
        this.myCookie = new Random().nextLong();
    }

    public static synchronized PortFile getPortFile(String filename) {
        PortFile pf;
        if (allPortFiles == null) {
            allPortFiles = new HashMap<String, PortFile>();
        }
        if ((pf = allPortFiles.get(filename)) != null) {
            try {
                if (!pf.exists()) {
                    pf = null;
                }
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }
        if (pf == null) {
            pf = new PortFile(filename);
            allPortFiles.put(filename, pf);
        }
        return pf;
    }

    long getCookie() {
        return this.myCookie;
    }

    int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public void addBuildTime(long inc) {
        this.totalBuildTime += inc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startServer() throws IOException, InterruptedException {
        long serverStart = System.currentTimeMillis();
        PortFile portFile = this.portFile = SjavacServer.getPortFile(this.portfilename);
        synchronized (portFile) {
            this.portFile.lock();
            this.portFile.getValues();
            if (this.portFile.containsPortInfo()) {
                Log.debug("Javac server not started because portfile exists!");
                this.portFile.unlock();
                return Main.Result.ERROR.exitCode;
            }
            this.sjavac = new SjavacImpl();
            this.sjavac = new PooledSjavac(this.sjavac, this.poolsize);
            this.sjavac = new IdleResetSjavac(this.sjavac, this, this.keepalive * 1000);
            this.serverSocket = new ServerSocket();
            InetAddress localhost = InetAddress.getByName(null);
            this.serverSocket.bind(new InetSocketAddress(localhost, 0));
            this.portFile.setValues(this.getPort(), this.getCookie());
            this.portFile.unlock();
        }
        this.portFileMonitor = new PortFileMonitor(this.portFile, this);
        this.portFileMonitor.start();
        Log.debug("Sjavac server started. Accepting connections...");
        Log.debug("    port: " + this.getPort());
        Log.debug("    time: " + new Date());
        Log.debug("    poolsize: " + this.poolsize);
        this.keepAcceptingRequests.set(true);
        do {
            try {
                Socket socket = this.serverSocket.accept();
                new RequestHandler(socket, this.sjavac).start();
            }
            catch (SocketException socket) {
                // empty catch block
            }
        } while (this.keepAcceptingRequests.get());
        Log.debug("Shutting down.");
        long realTime = System.currentTimeMillis() - serverStart;
        Log.debug("Total wall clock time " + realTime + "ms build time " + this.totalBuildTime + "ms");
        this.sjavac.shutdown();
        return Main.Result.OK.exitCode;
    }

    @Override
    public void shutdown(String quitMsg) {
        if (!this.keepAcceptingRequests.compareAndSet(true, false)) {
            return;
        }
        Log.debug("Quitting: " + quitMsg);
        this.portFileMonitor.shutdown();
        try {
            this.portFile.delete();
        }
        catch (IOException | InterruptedException e) {
            Log.error(e);
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            Log.error(e);
        }
    }
}

