/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractSuppressWarningsMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(name="SuppressWarningsDeprecated", summary="Suppressing \"deprecated\" is probably a typo for \"deprecation\"", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class SuppressWarningsDeprecated
extends AbstractSuppressWarningsMatcher {
    private static final Matcher<AnnotationTree> matcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isType((String)"java.lang.SuppressWarnings"), Matchers.hasArgumentWithValue((String)"value", (Matcher)Matchers.stringLiteral((String)"deprecated"))});

    public final Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        if (matcher.matches((Tree)annotationTree, state)) {
            return this.describeMatch(annotationTree, this.getSuggestedFix(annotationTree));
        }
        return Description.NO_MATCH;
    }

    @Override
    protected void processSuppressWarningsValues(List<String> values) {
        for (int i = 0; i < values.size(); ++i) {
            if (!values.get(i).equals("deprecated")) continue;
            values.set(i, "deprecation");
        }
    }
}

