/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Attributes;
import io.grpc.ExperimentalApi;
import io.grpc.NameResolver;
import io.grpc.ServiceProviders;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4159")
public abstract class NameResolverProvider
extends NameResolver.Factory {
    private static final Logger logger = Logger.getLogger(NameResolverProvider.class.getName());
    @Deprecated
    public static final Attributes.Key<Integer> PARAMS_DEFAULT_PORT = NameResolver.Factory.PARAMS_DEFAULT_PORT;
    @VisibleForTesting
    static final Iterable<Class<?>> HARDCODED_CLASSES = NameResolverProvider.getHardCodedClasses();
    private static final List<NameResolverProvider> providers = ServiceProviders.loadAll(NameResolverProvider.class, HARDCODED_CLASSES, NameResolverProvider.class.getClassLoader(), new NameResolverPriorityAccessor());
    private static final NameResolver.Factory factory = new NameResolverFactory(providers);

    public static List<NameResolverProvider> providers() {
        return providers;
    }

    public static NameResolver.Factory asFactory() {
        return factory;
    }

    @VisibleForTesting
    static NameResolver.Factory asFactory(List<NameResolverProvider> providers) {
        return new NameResolverFactory(providers);
    }

    protected abstract boolean isAvailable();

    protected abstract int priority();

    @VisibleForTesting
    static final List<Class<?>> getHardCodedClasses() {
        try {
            return Collections.singletonList(Class.forName("io.grpc.internal.DnsNameResolverProvider"));
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Unable to find DNS NameResolver", e);
            return Collections.emptyList();
        }
    }

    private static final class NameResolverPriorityAccessor
    implements ServiceProviders.PriorityAccessor<NameResolverProvider> {
        NameResolverPriorityAccessor() {
        }

        @Override
        public boolean isAvailable(NameResolverProvider provider) {
            return provider.isAvailable();
        }

        @Override
        public int getPriority(NameResolverProvider provider) {
            return provider.priority();
        }
    }

    private static final class NameResolverFactory
    extends NameResolver.Factory {
        private final List<NameResolverProvider> providers;

        NameResolverFactory(List<NameResolverProvider> providers) {
            this.providers = Collections.unmodifiableList(new ArrayList<NameResolverProvider>(providers));
        }

        @Override
        @Nullable
        public NameResolver newNameResolver(URI targetUri, NameResolver.Helper helper) {
            this.checkForProviders();
            for (NameResolverProvider provider : this.providers) {
                NameResolver resolver = provider.newNameResolver(targetUri, helper);
                if (resolver == null) continue;
                return resolver;
            }
            return null;
        }

        @Override
        public String getDefaultScheme() {
            this.checkForProviders();
            return this.providers.get(0).getDefaultScheme();
        }

        private void checkForProviders() {
            if (this.providers.isEmpty()) {
                String msg = "No NameResolverProviders found via ServiceLoader, including for DNS. This is probably due to a broken build. If using ProGuard, check your configuration";
                throw new RuntimeException(msg);
            }
        }
    }
}

