/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;

public class DescendantOf
implements Matcher<ExpressionTree> {
    private final String fullClassName;
    private final String methodName;

    public DescendantOf(String fullClassName, String methodName) {
        this.fullClassName = fullClassName;
        this.methodName = methodName;
    }

    @Override
    public boolean matches(ExpressionTree expressionTree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol(expressionTree);
        if (sym == null) {
            return false;
        }
        if (!(sym instanceof Symbol.MethodSymbol)) {
            throw new IllegalArgumentException("DescendantOf matcher expects a method call but found " + sym.getClass() + ". Expression: " + expressionTree);
        }
        if (sym.isStatic()) {
            return false;
        }
        if (this.methodName.equals(sym.toString())) {
            Type accessedReferenceType = sym.owner.type;
            Type collectionType = state.getTypeFromString(this.fullClassName);
            if (collectionType != null) {
                return state.getTypes().isSubtype(accessedReferenceType, state.getTypes().erasure(collectionType));
            }
        }
        return false;
    }
}

