/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.devtools.build.lib.skyframe.serialization.CodecRegisterer;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.BiFunction;

class MapEntryCodec
implements ObjectCodec<Map.Entry> {
    private final BiFunction<Object, Object, Map.Entry> factory;
    private final Class<? extends Map.Entry> type;

    private MapEntryCodec(BiFunction<Object, Object, Map.Entry> factory) {
        this.factory = factory;
        this.type = factory.apply(0, 0).getClass();
    }

    @Override
    public Class<? extends Map.Entry> getEncodedClass() {
        return this.type;
    }

    @Override
    public void serialize(SerializationContext context, Map.Entry entry, CodedOutputStream codedOut) throws IOException, SerializationException {
        context.serialize(entry.getKey(), codedOut);
        context.serialize(entry.getValue(), codedOut);
    }

    @Override
    public Map.Entry deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        return this.factory.apply(context.deserialize(codedIn), context.deserialize(codedIn));
    }

    private static class MapEntryCodecRegisterer
    implements CodecRegisterer<MapEntryCodec> {
        private MapEntryCodecRegisterer() {
        }

        @Override
        public Iterable<MapEntryCodec> getCodecsToRegister() {
            return ImmutableList.of((Object)new MapEntryCodec(Maps::immutableEntry), (Object)new MapEntryCodec(AbstractMap.SimpleEntry::new), (Object)new MapEntryCodec(AbstractMap.SimpleImmutableEntry::new));
        }
    }
}

