/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="GetClassOnClass", summary="Calling getClass() on an object of type Class returns the Class object for java.lang.Class; you probably meant to operate on the object directly", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class GetClassOnClass
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> getClassMethodMatcher = Matchers.instanceMethod().onExactClass("java.lang.Class").named("getClass");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (getClassMethodMatcher.matches((Tree)tree, state)) {
            String methodInvoker = ASTHelpers.getReceiver((ExpressionTree)tree).toString();
            SuggestedFix removeGetClass = SuggestedFix.replace((Tree)tree, (String)methodInvoker);
            SuggestedFix changeToClassDotClass = SuggestedFix.replace((Tree)tree, (String)"Class.class");
            return this.buildDescription(tree).addFix((Fix)removeGetClass).addFix((Fix)changeToClassDotClass).build();
        }
        return Description.NO_MATCH;
    }
}

