/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclint;

import com.sun.tools.doclint.HtmlVersion;
import com.sun.tools.javac.util.StringUtils;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Name;

public enum HtmlTag {
    A(BlockType.INLINE, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.ALL, Attr.HREF, Attr.TARGET, Attr.ID), HtmlTag.attrs(AttrKind.HTML4, Attr.REV, Attr.CHARSET, Attr.SHAPE, Attr.COORDS, Attr.NAME)),
    ABBR(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    ACRONYM(HtmlVersion.HTML4, BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    ADDRESS(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    ARTICLE(HtmlVersion.HTML5, BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    ASIDE(HtmlVersion.HTML5, BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    B(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    BDI(HtmlVersion.HTML5, BlockType.INLINE, EndKind.REQUIRED, new AttrMap[0]),
    BIG(HtmlVersion.HTML4, BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]),
    BLOCKQUOTE(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    BODY(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    BR(BlockType.INLINE, EndKind.NONE, HtmlTag.attrs(AttrKind.USE_CSS, Attr.CLEAR)),
    CAPTION(BlockType.TABLE_ITEM, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_INLINE, Flag.EXPECT_CONTENT), HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN)),
    CENTER(HtmlVersion.HTML4, BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    CITE(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    CODE(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    COL(BlockType.TABLE_ITEM, EndKind.NONE, HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF, Attr.VALIGN, Attr.WIDTH)),
    COLGROUP(BlockType.TABLE_ITEM, EndKind.REQUIRED, new AttrMap[]{HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF, Attr.VALIGN, Attr.WIDTH)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == COL;
        }
    }
    ,
    DD(BlockType.LIST_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE, Flag.EXPECT_CONTENT), new AttrMap[0]),
    DEL(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), HtmlTag.attrs(AttrKind.ALL, Attr.CITE, Attr.DATETIME)),
    DFN(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    DIV(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN)),
    DL(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.USE_CSS, Attr.COMPACT)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == DT || t == DD;
        }
    }
    ,
    DT(BlockType.LIST_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_INLINE, Flag.EXPECT_CONTENT), new AttrMap[0]),
    EM(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.NO_NEST), new AttrMap[0]),
    FONT(HtmlVersion.HTML4, BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), HtmlTag.attrs(AttrKind.USE_CSS, Attr.SIZE, Attr.COLOR, Attr.FACE)),
    FOOTER(HtmlVersion.HTML5, BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]){

        @Override
        public boolean accepts(HtmlTag t) {
            switch (t) {
                case HEADER: 
                case FOOTER: 
                case MAIN: {
                    return false;
                }
            }
            return t.blockType == BlockType.BLOCK || t.blockType == BlockType.INLINE;
        }
    }
    ,
    FIGURE(HtmlVersion.HTML5, BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    FIGCAPTION(HtmlVersion.HTML5, BlockType.BLOCK, EndKind.REQUIRED, new AttrMap[0]),
    FRAME(HtmlVersion.HTML4, BlockType.OTHER, EndKind.NONE, new AttrMap[0]),
    FRAMESET(HtmlVersion.HTML4, BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    H1(BlockType.BLOCK, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN)),
    H2(BlockType.BLOCK, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN)),
    H3(BlockType.BLOCK, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN)),
    H4(BlockType.BLOCK, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN)),
    H5(BlockType.BLOCK, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN)),
    H6(BlockType.BLOCK, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN)),
    HEAD(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    HEADER(HtmlVersion.HTML5, BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]){

        @Override
        public boolean accepts(HtmlTag t) {
            switch (t) {
                case HEADER: 
                case FOOTER: 
                case MAIN: {
                    return false;
                }
            }
            return t.blockType == BlockType.BLOCK || t.blockType == BlockType.INLINE;
        }
    }
    ,
    HR(BlockType.BLOCK, EndKind.NONE, HtmlTag.attrs(AttrKind.HTML4, Attr.WIDTH), HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN, Attr.NOSHADE, Attr.SIZE)),
    HTML(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    I(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    IFRAME(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    IMG(BlockType.INLINE, EndKind.NONE, HtmlTag.attrs(AttrKind.ALL, Attr.SRC, Attr.ALT, Attr.HEIGHT, Attr.WIDTH), HtmlTag.attrs(AttrKind.HTML5, Attr.CROSSORIGIN), HtmlTag.attrs(AttrKind.OBSOLETE, Attr.NAME), HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN, Attr.HSPACE, Attr.VSPACE, Attr.BORDER)),
    INS(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), HtmlTag.attrs(AttrKind.ALL, Attr.CITE, Attr.DATETIME)),
    KBD(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    LI(BlockType.LIST_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), HtmlTag.attrs(AttrKind.ALL, Attr.VALUE), HtmlTag.attrs(AttrKind.USE_CSS, Attr.TYPE)),
    LINK(BlockType.OTHER, EndKind.NONE, new AttrMap[0]),
    MAIN(HtmlVersion.HTML5, BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    MARK(HtmlVersion.HTML5, BlockType.INLINE, EndKind.REQUIRED, new AttrMap[0]),
    MENU(BlockType.BLOCK, EndKind.REQUIRED, new AttrMap[0]){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == LI;
        }
    }
    ,
    META(BlockType.OTHER, EndKind.NONE, new AttrMap[0]),
    NAV(HtmlVersion.HTML5, BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    NOFRAMES(HtmlVersion.HTML4, BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    NOSCRIPT(BlockType.BLOCK, EndKind.REQUIRED, new AttrMap[0]),
    OL(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.ALL, Attr.START, Attr.TYPE), HtmlTag.attrs(AttrKind.HTML5, Attr.REVERSED), HtmlTag.attrs(AttrKind.USE_CSS, Attr.COMPACT)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == LI;
        }
    }
    ,
    P(BlockType.BLOCK, EndKind.OPTIONAL, EnumSet.of(Flag.EXPECT_CONTENT), HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN)),
    PRE(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.USE_CSS, Attr.WIDTH)}){

        @Override
        public boolean accepts(HtmlTag t) {
            switch (t) {
                case IMG: 
                case BIG: 
                case SMALL: 
                case SUB: 
                case SUP: {
                    return false;
                }
            }
            return t.blockType == BlockType.INLINE;
        }
    }
    ,
    Q(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    S(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    SAMP(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    SCRIPT(BlockType.OTHER, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.ALL, Attr.SRC)),
    SECTION(HtmlVersion.HTML5, BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    SMALL(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]),
    SPAN(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]),
    STRIKE(HtmlVersion.HTML4, BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]),
    STRONG(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]),
    SUB(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    SUP(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    TABLE(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.ALL, Attr.BORDER), HtmlTag.attrs(AttrKind.HTML4, Attr.SUMMARY, Attr.CELLPADDING, Attr.CELLSPACING, Attr.FRAME, Attr.RULES, Attr.WIDTH), HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN, Attr.BGCOLOR)}){

        @Override
        public boolean accepts(HtmlTag t) {
            switch (t) {
                case CAPTION: 
                case COLGROUP: 
                case THEAD: 
                case TBODY: 
                case TFOOT: 
                case TR: {
                    return true;
                }
            }
            return false;
        }
    }
    ,
    TBODY(BlockType.TABLE_ITEM, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.ALL, Attr.VALIGN), HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == TR;
        }
    }
    ,
    TD(BlockType.TABLE_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), HtmlTag.attrs(AttrKind.ALL, Attr.COLSPAN, Attr.ROWSPAN, Attr.HEADERS, Attr.VALIGN), HtmlTag.attrs(AttrKind.HTML4, Attr.AXIS, Attr.ABBR, Attr.SCOPE, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF), HtmlTag.attrs(AttrKind.USE_CSS, Attr.WIDTH, Attr.BGCOLOR, Attr.HEIGHT, Attr.NOWRAP)),
    TEMPLATE(HtmlVersion.HTML5, BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    TFOOT(BlockType.TABLE_ITEM, EndKind.REQUIRED, new AttrMap[]{HtmlTag.attrs(AttrKind.ALL, Attr.VALIGN), HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == TR;
        }
    }
    ,
    TH(BlockType.TABLE_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), HtmlTag.attrs(AttrKind.ALL, Attr.COLSPAN, Attr.ROWSPAN, Attr.HEADERS, Attr.SCOPE, Attr.ABBR, Attr.VALIGN), HtmlTag.attrs(AttrKind.HTML4, Attr.AXIS, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF), HtmlTag.attrs(AttrKind.USE_CSS, Attr.WIDTH, Attr.BGCOLOR, Attr.HEIGHT, Attr.NOWRAP)),
    THEAD(BlockType.TABLE_ITEM, EndKind.REQUIRED, new AttrMap[]{HtmlTag.attrs(AttrKind.ALL, Attr.VALIGN), HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == TR;
        }
    }
    ,
    TIME(HtmlVersion.HTML5, BlockType.INLINE, EndKind.REQUIRED, new AttrMap[0]),
    TITLE(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    TR(BlockType.TABLE_ITEM, EndKind.OPTIONAL, new AttrMap[]{HtmlTag.attrs(AttrKind.ALL, Attr.VALIGN), HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF), HtmlTag.attrs(AttrKind.USE_CSS, Attr.BGCOLOR)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == TH || t == TD;
        }
    }
    ,
    TT(HtmlVersion.HTML4, BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    U(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    UL(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.HTML4, Attr.COMPACT, Attr.TYPE)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == LI;
        }
    }
    ,
    WBR(HtmlVersion.HTML5, BlockType.INLINE, EndKind.REQUIRED, new AttrMap[0]),
    VAR(BlockType.INLINE, EndKind.REQUIRED, new AttrMap[0]);

    public final HtmlVersion allowedVersion;
    public final BlockType blockType;
    public final EndKind endKind;
    public final Set<Flag> flags;
    private final Map<Attr, AttrKind> attrs;
    private static final Map<String, HtmlTag> index;

    private HtmlTag(BlockType blockType, EndKind endKind, AttrMap ... attrMaps) {
        this(HtmlVersion.ALL, blockType, endKind, Collections.emptySet(), attrMaps);
    }

    private HtmlTag(HtmlVersion allowedVersion, BlockType blockType, EndKind endKind, AttrMap ... attrMaps) {
        this(allowedVersion, blockType, endKind, Collections.emptySet(), attrMaps);
    }

    private HtmlTag(BlockType blockType, EndKind endKind, Set<Flag> flags, AttrMap ... attrMaps) {
        this(HtmlVersion.ALL, blockType, endKind, flags, attrMaps);
    }

    private HtmlTag(HtmlVersion allowedVersion, BlockType blockType, EndKind endKind, Set<Flag> flags, AttrMap ... attrMaps) {
        this.allowedVersion = allowedVersion;
        this.blockType = blockType;
        this.endKind = endKind;
        this.flags = flags;
        this.attrs = new EnumMap<Attr, AttrKind>(Attr.class);
        for (AttrMap m : attrMaps) {
            this.attrs.putAll(m);
        }
        this.attrs.put(Attr.CLASS, AttrKind.ALL);
        this.attrs.put(Attr.ID, AttrKind.ALL);
        this.attrs.put(Attr.STYLE, AttrKind.ALL);
        this.attrs.put(Attr.ROLE, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_ACTIVEDESCENDANT, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_CONTROLS, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_DESCRIBEDBY, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_EXPANDED, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_LABEL, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_LABELLEDBY, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_LEVEL, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_MULTISELECTABLE, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_OWNS, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_POSINSET, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_READONLY, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_REQUIRED, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_SELECTED, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_SETSIZE, AttrKind.HTML5);
        this.attrs.put(Attr.ARIA_SORT, AttrKind.HTML5);
    }

    public boolean accepts(HtmlTag t) {
        if (this.flags.contains((Object)Flag.ACCEPTS_BLOCK) && this.flags.contains((Object)Flag.ACCEPTS_INLINE)) {
            return t.blockType == BlockType.BLOCK || t.blockType == BlockType.INLINE;
        }
        if (this.flags.contains((Object)Flag.ACCEPTS_BLOCK)) {
            return t.blockType == BlockType.BLOCK;
        }
        if (this.flags.contains((Object)Flag.ACCEPTS_INLINE)) {
            return t.blockType == BlockType.INLINE;
        }
        switch (this.blockType) {
            case BLOCK: 
            case INLINE: {
                return t.blockType == BlockType.INLINE;
            }
            case OTHER: {
                return true;
            }
        }
        throw new AssertionError((Object)(this + ":" + t));
    }

    public boolean acceptsText() {
        return this.accepts(B);
    }

    public String getText() {
        return StringUtils.toLowerCase(this.name());
    }

    public Attr getAttr(Name attrName) {
        return Attr.index.get(StringUtils.toLowerCase(attrName.toString()));
    }

    public AttrKind getAttrKind(Name attrName) {
        AttrKind k = this.attrs.get((Object)this.getAttr(attrName));
        return k == null ? AttrKind.INVALID : k;
    }

    private static AttrMap attrs(AttrKind k, Attr ... attrs) {
        AttrMap map = new AttrMap();
        for (Attr a : attrs) {
            map.put(a, k);
        }
        return map;
    }

    public static HtmlTag get(Name tagName) {
        return index.get(StringUtils.toLowerCase(tagName.toString()));
    }

    static {
        index = new HashMap<String, HtmlTag>();
        for (HtmlTag t : HtmlTag.values()) {
            index.put(t.getText(), t);
        }
    }

    private static class AttrMap
    extends EnumMap<Attr, AttrKind> {
        private static final long serialVersionUID = 0L;

        AttrMap() {
            super(Attr.class);
        }
    }

    public static enum AttrKind {
        HTML4,
        HTML5,
        INVALID,
        OBSOLETE,
        USE_CSS,
        ALL;

    }

    public static enum Attr {
        ABBR,
        ALIGN,
        ALINK,
        ALT,
        ARIA_ACTIVEDESCENDANT,
        ARIA_CONTROLS,
        ARIA_DESCRIBEDBY,
        ARIA_EXPANDED,
        ARIA_LABEL,
        ARIA_LABELLEDBY,
        ARIA_LEVEL,
        ARIA_MULTISELECTABLE,
        ARIA_OWNS,
        ARIA_POSINSET,
        ARIA_SETSIZE,
        ARIA_READONLY,
        ARIA_REQUIRED,
        ARIA_SELECTED,
        ARIA_SORT,
        AXIS,
        BACKGROUND,
        BGCOLOR,
        BORDER,
        CELLSPACING,
        CELLPADDING,
        CHAR,
        CHAROFF,
        CHARSET,
        CITE,
        CLEAR,
        CLASS,
        COLOR,
        COLSPAN,
        COMPACT,
        COORDS,
        CROSSORIGIN,
        DATETIME,
        FACE,
        FRAME,
        FRAMEBORDER,
        HEADERS,
        HEIGHT,
        HREF,
        HSPACE,
        ID,
        LINK,
        LONGDESC,
        MARGINHEIGHT,
        MARGINWIDTH,
        NAME,
        NOSHADE,
        NOWRAP,
        PROFILE,
        REV,
        REVERSED,
        ROLE,
        ROWSPAN,
        RULES,
        SCHEME,
        SCOPE,
        SCROLLING,
        SHAPE,
        SIZE,
        SPACE,
        SRC,
        START,
        STYLE,
        SUMMARY,
        TARGET,
        TEXT,
        TYPE,
        VALIGN,
        VALUE,
        VERSION,
        VLINK,
        VSPACE,
        WIDTH;

        private final String name = StringUtils.toLowerCase(this.name().replace("_", "-"));
        static final Map<String, Attr> index;

        public String getText() {
            return this.name;
        }

        static {
            index = new HashMap<String, Attr>();
            for (Attr t : Attr.values()) {
                index.put(t.getText(), t);
            }
        }
    }

    public static enum Flag {
        ACCEPTS_BLOCK,
        ACCEPTS_INLINE,
        EXPECT_CONTENT,
        NO_NEST;

    }

    public static enum EndKind {
        NONE,
        OPTIONAL,
        REQUIRED;

    }

    public static enum BlockType {
        BLOCK,
        INLINE,
        LIST_ITEM,
        TABLE_ITEM,
        OTHER;

    }
}

