/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.NotSerializableRuntimeException;
import java.io.NotSerializableException;
import java.util.ArrayList;

public class SerializationException
extends Exception {
    private final ArrayList<String> trail = new ArrayList();

    public SerializationException(String msg) {
        super(msg);
    }

    public SerializationException(String msg, Throwable cause) {
        super(msg, cause);
    }

    @Override
    public String getMessage() {
        return super.getMessage() + (this.trail.isEmpty() ? "" : " " + this.trail);
    }

    public void addTrail(Class<?> type) {
        this.trail.add(type.getName());
    }

    public ImmutableList<String> getTrailForTesting() {
        return ImmutableList.copyOf(this.trail);
    }

    public static SerializationException propagate(String msg, Throwable cause) {
        if (cause instanceof NoCodecException) {
            return new NoCodecException(msg, (NoCodecException)cause);
        }
        return new SerializationException(msg, cause);
    }

    public static class NoCodecException
    extends SerializationException {
        NoCodecException(String message) {
            super(message);
        }

        NoCodecException(String message, Class<?> type) {
            super(message);
            this.addTrail(type);
        }

        NoCodecException(String message, NotSerializableException e) {
            super(message, e);
        }

        NoCodecException(String message, NotSerializableRuntimeException e) {
            super(message, e);
        }

        NoCodecException(String message, NoCodecException e) {
            super(message, e);
        }
    }
}

