/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.instrumentation.common.Provider;
import com.google.instrumentation.common.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

public final class TimestampFactory {
    private static final Logger logger = Logger.getLogger(TimestampFactory.class.getName());
    private static final Handler HANDLER = TimestampFactory.loadTimestampFactoryHandler(Provider.getCorrectClassLoader(Handler.class));

    private TimestampFactory() {
    }

    public static Timestamp now() {
        return HANDLER.timeNow();
    }

    @VisibleForTesting
    static Handler loadTimestampFactoryHandler(ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("com.google.instrumentation.common.TimestampFactoryHandlerImpl", true, classLoader), Handler.class);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Using default implementation for TimestampFactory$Handler.", e);
            return new DefaultHandler();
        }
    }

    @Immutable
    static final class DefaultHandler
    implements Handler {
        DefaultHandler() {
        }

        @Override
        public Timestamp timeNow() {
            return Timestamp.fromMillis(System.currentTimeMillis());
        }
    }

    static interface Handler {
        public Timestamp timeNow();
    }
}

