/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.comp.CompilationService;
import com.sun.tools.sjavac.options.Options;
import com.sun.tools.sjavac.pubapi.PubApi;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CompileProperties
implements Transformer {
    String extra;
    private static final String FORMAT = "{0}public final class {1} extends {2} '{'\n    protected final Object[][] getContents() '{'\n        return new Object[][] '{'\n{3}        };\n    }\n}\n";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @Override
    public void setExtra(String e) {
        this.extra = e;
    }

    @Override
    public void setExtra(Options a) {
    }

    @Override
    public boolean transform(CompilationService compilationService, Map<String, Set<URI>> pkgSrcs, Set<URI> visibleSrcs, Map<String, Set<String>> oldPackageDependents, URI destRoot, Map<String, Set<URI>> packageArtifacts, Map<String, Map<String, Set<String>>> packageDependencies, Map<String, Map<String, Set<String>>> packageCpDependencies, Map<String, PubApi> packagePublicApis, Map<String, PubApi> dependencyPublicApis, int debugLevel, boolean incremental, int numCores) {
        boolean rc = true;
        for (String pkgName : pkgSrcs.keySet()) {
            String pkgNameF = Util.toFileSystemPath(pkgName);
            for (URI u : pkgSrcs.get(pkgName)) {
                File src = new File(u);
                boolean r = this.compile(pkgName, pkgNameF, src, new File(destRoot), debugLevel, packageArtifacts);
                if (r) continue;
                rc = false;
            }
        }
        return rc;
    }

    boolean compile(String pkgName, String pkgNameF, File src, File destRoot, int debugLevel, Map<String, Set<URI>> packageArtifacts) {
        String superClass = "java.util.ListResourceBundle";
        if (this.extra != null) {
            superClass = this.extra;
        }
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(src));
        }
        catch (IOException e) {
            Log.error("Error reading file " + src.getPath());
            return false;
        }
        int dp = src.getName().lastIndexOf(".");
        String classname = src.getName().substring(0, dp);
        ArrayList<String> sortedKeys = new ArrayList<String>();
        for (Object key : p.keySet()) {
            sortedKeys.add((String)key);
        }
        Collections.sort(sortedKeys);
        Iterator keys = sortedKeys.iterator();
        StringBuilder data = new StringBuilder();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            data.append("            { \"" + CompileProperties.escape(key) + "\", \"" + CompileProperties.escape((String)p.get(key)) + "\" },\n");
        }
        String destFilename = destRoot.getPath() + File.separator + pkgNameF + File.separator + classname + ".java";
        File dest = new File(destFilename);
        if (!dest.getParentFile().isDirectory() && !dest.getParentFile().mkdirs()) {
            Log.error("Could not create the directory " + dest.getParentFile().getPath());
            return false;
        }
        Set<URI> as = packageArtifacts.get(pkgName);
        if (as == null) {
            as = new HashSet<URI>();
            packageArtifacts.put(pkgName, as);
        }
        as.add(dest.toURI());
        if (dest.exists() && dest.lastModified() > src.lastModified()) {
            return true;
        }
        String packageString = "package " + pkgNameF.replace(File.separatorChar, '.') + ";\n\n";
        Log.info("Compiling property file " + pkgNameF + File.separator + src.getName());
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dest)));){
            MessageFormat format = new MessageFormat(FORMAT);
            writer.write(format.format(new Object[]{packageString, classname, superClass, data}));
        }
        catch (IOException e) {
            Log.error("Could not write file " + dest.getPath());
            return false;
        }
        return true;
    }

    public static String escape(String theString) {
        int len = theString.length();
        StringBuilder outBuffer = new StringBuilder(len * 2);
        block7: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block7;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block7;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block7;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block7;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block7;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(CompileProperties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(CompileProperties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(CompileProperties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(CompileProperties.toHex(aChar & 0xF));
                        continue block7;
                    }
                    if (aChar == '\"') {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

