/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.util.HashSet;
import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class StringSwitchEcjFilter
implements IFilter {
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        Matcher matcher = new Matcher();
        for (AbstractInsnNode i = methodNode.instructions.getFirst(); i != null; i = i.getNext()) {
            matcher.match(i, output);
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        public void match(AbstractInsnNode start, IFilterOutput output) {
            int hashCodes;
            LabelNode defaultLabel;
            if (58 != start.getOpcode()) {
                return;
            }
            this.cursor = start;
            this.nextIsInvokeVirtual("java/lang/String", "hashCode");
            this.nextIsSwitch();
            if (this.cursor == null) {
                return;
            }
            this.vars.put("s", (VarInsnNode)start);
            AbstractInsnNode s = this.cursor;
            if (s.getOpcode() == 171) {
                LookupSwitchInsnNode lookupSwitch = (LookupSwitchInsnNode)this.cursor;
                defaultLabel = lookupSwitch.dflt;
                hashCodes = lookupSwitch.labels.size();
            } else {
                TableSwitchInsnNode tableSwitch = (TableSwitchInsnNode)this.cursor;
                defaultLabel = tableSwitch.dflt;
                hashCodes = tableSwitch.labels.size();
            }
            HashSet<AbstractInsnNode> replacements = new HashSet<AbstractInsnNode>();
            replacements.add(Matcher.skipNonOpcodes((AbstractInsnNode)defaultLabel));
            block0: for (int i = 0; i < hashCodes; ++i) {
                do {
                    this.nextIsVar(25, "s");
                    this.nextIs(18);
                    this.nextIsInvokeVirtual("java/lang/String", "equals");
                    this.nextIs(154);
                    if (this.cursor == null) {
                        return;
                    }
                    replacements.add(Matcher.skipNonOpcodes((AbstractInsnNode)((JumpInsnNode)this.cursor).label));
                    if (this.cursor.getNext().getOpcode() != 167) continue;
                    this.nextIs(167);
                    continue block0;
                } while (this.cursor.getNext() != defaultLabel);
            }
            output.ignore(s.getNext(), this.cursor);
            output.replaceBranches(s, replacements);
        }
    }
}

