/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.Tree;

final class DaggerAnnotations {
    static final String BINDS_CLASS_NAME = "dagger.Binds";
    static final String PROVIDES_CLASS_NAME = "dagger.Provides";
    static final String MODULE_CLASS_NAME = "dagger.Module";
    static final String MULTIBINDS_CLASS_NAME = "dagger.multibindings.Multibinds";
    static final String PRODUCES_CLASS_NAME = "dagger.producers.Produces";
    static final String PRODUCER_MODULE_CLASS_NAME = "dagger.producers.ProducerModule";
    static final String INTO_SET_CLASS_NAME = "dagger.multibindings.IntoSet";
    static final String ELEMENTS_INTO_SET_CLASS_NAME = "dagger.multibindings.ElementsIntoSet";
    static final String INTO_MAP_CLASS_NAME = "dagger.multibindings.IntoMap";

    static <T extends Tree> Matcher<T> isModule() {
        return Matchers.hasAnnotation((String)MODULE_CLASS_NAME);
    }

    static <T extends Tree> Matcher<T> isProvidesMethod() {
        return Matchers.hasAnnotation((String)PROVIDES_CLASS_NAME);
    }

    static <T extends Tree> Matcher<T> isBindsMethod() {
        return Matchers.hasAnnotation((String)BINDS_CLASS_NAME);
    }

    static <T extends Tree> Matcher<T> isMultibindsMethod() {
        return Matchers.hasAnnotation((String)MULTIBINDS_CLASS_NAME);
    }

    static <T extends Tree> Matcher<T> isProducerModule() {
        return Matchers.hasAnnotation((String)PRODUCER_MODULE_CLASS_NAME);
    }

    static <T extends Tree> Matcher<T> isProducesMethod() {
        return Matchers.hasAnnotation((String)PRODUCES_CLASS_NAME);
    }

    static <T extends Tree> Matcher<T> isMultibindingMethod() {
        return Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotation((String)INTO_SET_CLASS_NAME), Matchers.hasAnnotation((String)ELEMENTS_INTO_SET_CLASS_NAME), Matchers.hasAnnotation((String)INTO_MAP_CLASS_NAME)});
    }

    static <T extends Tree> Matcher<T> isAnyModule() {
        return Matchers.anyOf((Matcher[])new Matcher[]{DaggerAnnotations.isModule(), DaggerAnnotations.isProducerModule()});
    }

    static <T extends Tree> Matcher<T> isBindingMethod() {
        return Matchers.anyOf((Matcher[])new Matcher[]{DaggerAnnotations.isProvidesMethod(), DaggerAnnotations.isProducesMethod()});
    }

    static <T extends Tree> Matcher<T> isBindingDeclarationMethod() {
        return Matchers.anyOf((Matcher[])new Matcher[]{DaggerAnnotations.isBindsMethod(), DaggerAnnotations.isMultibindsMethod()});
    }

    static <T extends Tree> Matcher<T> isAnyBindingDeclaringMethod() {
        return Matchers.anyOf((Matcher[])new Matcher[]{DaggerAnnotations.isBindingMethod(), DaggerAnnotations.isBindingDeclarationMethod()});
    }

    private DaggerAnnotations() {
    }
}

