// Copyright 2020 The Bazel Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Starlark CPU profiler stubs for unsupported platforms.

#include <jni.h>
#include <stdlib.h>

namespace cpu_profiler {

extern "C" JNIEXPORT jboolean JNICALL
Java_net_starlark_java_eval_CpuProfilerNativeSupportImpl_supported(
    JNIEnv* env, jobject instance) {
  return false;
}

extern "C" JNIEXPORT jint JNICALL
Java_net_starlark_java_eval_CpuProfilerNativeSupportImpl_getThreadId(
    JNIEnv* env, jobject instance) {
  abort();
}

extern "C" JNIEXPORT jobject JNICALL
Java_net_starlark_java_eval_CpuProfilerNativeSupportImpl_createPipe(
    JNIEnv* env, jobject instance) {
  abort();
}

extern "C" JNIEXPORT jboolean JNICALL
Java_net_starlark_java_eval_CpuProfilerNativeSupportImpl_startTimer(
    JNIEnv* env, jobject instance, jlong period_micros) {
  abort();
}

extern "C" JNIEXPORT void JNICALL
Java_net_starlark_java_eval_CpuProfilerNativeSupportImpl_stopTimer(
    JNIEnv* env, jobject instance) {
  abort();
}

}  // namespace cpu_profiler
