/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.util.List;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class MemberDescriptorFilter
implements MemberVisitor {
    private final StringMatcher regularExpressionMatcher;
    private final MemberVisitor memberVisitor;

    public MemberDescriptorFilter(String regularExpression, MemberVisitor memberVisitor) {
        this(regularExpression, null, memberVisitor);
    }

    public MemberDescriptorFilter(String regularExpression, List variableStringMatchers, MemberVisitor memberVisitor) {
        this(new ListParser(new ClassNameParser(variableStringMatchers)).parse(regularExpression), memberVisitor);
    }

    public MemberDescriptorFilter(StringMatcher regularExpressionMatcher, MemberVisitor memberVisitor) {
        this.regularExpressionMatcher = regularExpressionMatcher;
        this.memberVisitor = memberVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.accepted(programField.getDescriptor(programClass))) {
            this.memberVisitor.visitProgramField(programClass, programField);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.accepted(programMethod.getDescriptor(programClass))) {
            this.memberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (this.accepted(libraryField.getDescriptor(libraryClass))) {
            this.memberVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.accepted(libraryMethod.getDescriptor(libraryClass))) {
            this.memberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }

    private boolean accepted(String name) {
        return this.regularExpressionMatcher.matches(name);
    }
}

