/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.errorprone.refaster.AutoValue_UClassDecl;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UMethodDecl;
import com.google.errorprone.refaster.USimpleStatement;
import com.google.errorprone.refaster.UTree;
import com.google.errorprone.refaster.UVariableDecl;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import javax.lang.model.element.Name;

@AutoValue
abstract class UClassDecl
extends USimpleStatement
implements ClassTree {
    UClassDecl() {
    }

    public static UClassDecl create(UMethodDecl ... members) {
        return UClassDecl.create((Iterable<UMethodDecl>)ImmutableList.copyOf((Object[])members));
    }

    public static UClassDecl create(Iterable<UMethodDecl> members) {
        return new AutoValue_UClassDecl((ImmutableList<UMethodDecl>)ImmutableList.copyOf(members));
    }

    private static Function<UnifierWithRemainingMembers, Choice<UnifierWithRemainingMembers>> match(Tree tree) {
        return state -> {
            ImmutableList<UMethodDecl> currentMembers = state.remainingMembers();
            Choice<Integer> methodChoice = Choice.from(ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(currentMembers.size())), (DiscreteDomain)DiscreteDomain.integers()));
            return methodChoice.flatMap(i -> {
                ImmutableList remainingMembers = ImmutableList.builder().addAll((Iterable)currentMembers.subList(0, i.intValue())).addAll((Iterable)currentMembers.subList(i + 1, currentMembers.size())).build();
                UMethodDecl chosenMethod = (UMethodDecl)currentMembers.get(i.intValue());
                Unifier unifier = state.unifier().fork();
                for (UVariableDecl param : chosenMethod.getParameters()) {
                    unifier.clearBinding(param.key());
                }
                return chosenMethod.unify(tree, unifier).map(UnifierWithRemainingMembers.withRemaining((Iterable<UMethodDecl>)remainingMembers));
            });
        };
    }

    @Override
    public Choice<Unifier> visitClass(ClassTree node, Unifier unifier) {
        Choice<UnifierWithRemainingMembers> path = Choice.of(UnifierWithRemainingMembers.create(unifier, this.getMembers()));
        for (Tree tree : node.getMembers()) {
            MethodTree methodTree;
            if (tree instanceof MethodTree && ASTHelpers.isGeneratedConstructor((MethodTree)(methodTree = (MethodTree)tree))) continue;
            path = path.flatMap(UClassDecl.match(tree));
        }
        return path.filter(s -> s.remainingMembers().isEmpty()).map(UnifierWithRemainingMembers::unifier);
    }

    @Override
    public JCTree.JCClassDecl inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.maker().AnonymousClassDef(inliner.maker().Modifiers(0L), List.convert(JCTree.class, inliner.inlineList(this.getMembers())));
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitClass(this, data);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CLASS;
    }

    @Override
    public UTree<?> getExtendsClause() {
        return null;
    }

    public ImmutableList<UTree<?>> getImplementsClause() {
        return ImmutableList.of();
    }

    public abstract ImmutableList<UMethodDecl> getMembers();

    @Override
    public ModifiersTree getModifiers() {
        return null;
    }

    @Override
    public Name getSimpleName() {
        return null;
    }

    public ImmutableList<TypeParameterTree> getTypeParameters() {
        return ImmutableList.of();
    }

    private record UnifierWithRemainingMembers(Unifier unifier, ImmutableList<UMethodDecl> remainingMembers) {
        static UnifierWithRemainingMembers create(Unifier unifier, Iterable<UMethodDecl> remainingMembers) {
            return new UnifierWithRemainingMembers(unifier, (ImmutableList<UMethodDecl>)ImmutableList.copyOf(remainingMembers));
        }

        static Function<Unifier, UnifierWithRemainingMembers> withRemaining(Iterable<UMethodDecl> remainingMembers) {
            return unifier -> UnifierWithRemainingMembers.create(unifier, remainingMembers);
        }
    }
}

