/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.refaster.AutoValue_ExpressionTemplate;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.ExpressionTemplateMatch;
import com.google.errorprone.refaster.ImportPolicy;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.Template;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UPlaceholderExpression;
import com.google.errorprone.refaster.UPlaceholderStatement;
import com.google.errorprone.refaster.UPrimitiveType;
import com.google.errorprone.refaster.UType;
import com.google.errorprone.refaster.UTypeVar;
import com.google.errorprone.refaster.Unifiable;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.refaster.annotation.AlsoNegation;
import com.google.errorprone.refaster.annotation.UseImportPolicy;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Warner;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;

@AutoValue
public abstract class ExpressionTemplate
extends Template<ExpressionTemplateMatch>
implements Unifiable<JCTree.JCExpression> {
    private static final Logger logger = Logger.getLogger(ExpressionTemplate.class.toString());
    static final TreeScanner<Boolean, Unifier> PLACEHOLDER_VERIFIER = new TreeScanner<Boolean, Unifier>(){

        @Override
        public Boolean reduce(Boolean a, Boolean b) {
            return ExpressionTemplate.trueOrNull(a) && ExpressionTemplate.trueOrNull(b);
        }

        @Override
        public Boolean visitOther(Tree t, Unifier u) {
            if (t instanceof UPlaceholderExpression) {
                UPlaceholderExpression uPlaceholderExpression = (UPlaceholderExpression)t;
                return uPlaceholderExpression.reverify(u);
            }
            if (t instanceof UPlaceholderStatement) {
                UPlaceholderStatement uPlaceholderStatement = (UPlaceholderStatement)t;
                return uPlaceholderStatement.reverify(u);
            }
            return (Boolean)super.visitOther(t, u);
        }
    };

    public static ExpressionTemplate create(UExpression expression, UType returnType) {
        return ExpressionTemplate.create((Map<String, ? extends UType>)ImmutableMap.of(), expression, returnType);
    }

    public static ExpressionTemplate create(Map<String, ? extends UType> expressionArgumentTypes, UExpression expression, UType returnType) {
        return ExpressionTemplate.create((ImmutableClassToInstanceMap<Annotation>)ImmutableClassToInstanceMap.of(), (Iterable<UTypeVar>)ImmutableList.of(), expressionArgumentTypes, expression, returnType);
    }

    public static ExpressionTemplate create(ImmutableClassToInstanceMap<Annotation> annotations, Iterable<UTypeVar> typeVariables, Map<String, ? extends UType> expressionArgumentTypes, UExpression expression, UType returnType) {
        return new AutoValue_ExpressionTemplate(annotations, (ImmutableList<UTypeVar>)ImmutableList.copyOf(typeVariables), (ImmutableMap<String, UType>)ImmutableMap.copyOf(expressionArgumentTypes), expression, returnType);
    }

    abstract UExpression expression();

    abstract UType returnType();

    public boolean generateNegation() {
        return this.annotations().containsKey(AlsoNegation.class);
    }

    public ExpressionTemplate negation() {
        Preconditions.checkState((boolean)this.returnType().equals(UPrimitiveType.BOOLEAN), (String)"Return type must be boolean to generate negation, but was %s", (Object)this.returnType());
        return ExpressionTemplate.create(this.annotations(), this.templateTypeVariables(), this.expressionArgumentTypes(), this.expression().negate(), this.returnType());
    }

    @Override
    public Iterable<ExpressionTemplateMatch> match(JCTree target, Context context) {
        JCTree.JCExpression targetExpr;
        Optional<Unifier> unifier;
        if (target instanceof JCTree.JCExpression && (unifier = this.unify(targetExpr = (JCTree.JCExpression)target, new Unifier(context)).findFirst()).isPresent()) {
            return ImmutableList.of((Object)new ExpressionTemplateMatch(targetExpr, unifier.get()));
        }
        return ImmutableList.of();
    }

    static boolean trueOrNull(@Nullable Boolean b) {
        return b == null || b != false;
    }

    @Override
    public Choice<Unifier> unify(final JCTree.JCExpression target, Unifier unifier) {
        return this.expression().unify(target, unifier).filter(u -> ExpressionTemplate.trueOrNull(PLACEHOLDER_VERIFIER.scan(this.expression(), (Unifier)u))).mapIfPresent(new Function<Unifier, Optional<Unifier>>(){
            final /* synthetic */ ExpressionTemplate this$0;
            {
                this.this$0 = this$0;
            }

            public Optional<Unifier> apply(Unifier unifier) {
                Inliner inliner = unifier.createInliner();
                try {
                    List<Type> expectedTypes = this.this$0.expectedTypes(inliner);
                    List<Type> actualTypes = this.this$0.actualTypes(inliner);
                    if (target.type.getTag() != TypeTag.VOID) {
                        expectedTypes = expectedTypes.prepend((Type)this.this$0.returnType().inline(inliner));
                        Type ty = target.type;
                        if (target instanceof ConditionalExpressionTree) {
                            JCTree.JCConditional cond = (JCTree.JCConditional)target;
                            Type trueTy = cond.truepart.type;
                            Type falseTy = cond.falsepart.type;
                            ty = trueTy.getTag() == TypeTag.BOT ? falseTy : (falseTy.getTag() == TypeTag.BOT ? trueTy : Types.instance(unifier.getContext()).lub(trueTy, falseTy));
                        }
                        actualTypes = actualTypes.prepend(ty);
                    }
                    return this.this$0.typecheck(unifier, inliner, new Warner(target), expectedTypes, actualTypes);
                }
                catch (CouldNotResolveImportException e) {
                    logger.log(Level.FINE, "Failure to resolve import", e);
                    return Optional.empty();
                }
            }
        });
    }

    @Override
    public Fix replace(ExpressionTemplateMatch match) {
        Inliner inliner = match.createInliner();
        Context context = inliner.getContext();
        if (this.annotations().containsKey(UseImportPolicy.class)) {
            ImportPolicy.bind(context, ((UseImportPolicy)this.annotations().getInstance(UseImportPolicy.class)).value());
        } else {
            ImportPolicy.bind(context, ImportPolicy.IMPORT_TOP_LEVEL);
        }
        int prec = ExpressionTemplate.getPrecedence(match.getLocation(), context);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        try {
            StringWriter writer = new StringWriter();
            ExpressionTemplate.pretty(inliner.getContext(), writer).printExpr((JCTree)this.expression().inline(inliner), prec);
            fix.replace((Tree)match.getLocation(), writer.toString());
        }
        catch (CouldNotResolveImportException e) {
            logger.log(Level.SEVERE, "Failure to resolve in replacement", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ExpressionTemplate.addImports(inliner, fix);
    }

    private static int getPrecedence(JCTree leaf, Context context) {
        JCTree parent;
        JCTree.JCCompilationUnit comp = context.get(JCTree.JCCompilationUnit.class);
        JCTree jCTree = parent = (JCTree)JavacTrees.instance(context).getPath(comp, leaf).getParentPath().getLeaf();
        Objects.requireNonNull(jCTree);
        JCTree jCTree2 = jCTree;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JCTree.JCConditional.class, JCTree.JCAssign.class, JCTree.JCAssignOp.class, JCTree.JCUnary.class, JCTree.JCBinary.class, JCTree.JCTypeCast.class, JCTree.JCInstanceOf.class, JCTree.JCArrayAccess.class, JCTree.JCFieldAccess.class}, (Object)jCTree2, n)) {
            case 0 -> {
                JCTree.JCConditional conditional = (JCTree.JCConditional)jCTree2;
                yield 3 + (conditional.cond == leaf ? 1 : 0);
            }
            case 1 -> {
                JCTree.JCAssign assign = (JCTree.JCAssign)jCTree2;
                yield 1 + (assign.lhs == leaf ? 1 : 0);
            }
            case 2 -> {
                JCTree.JCAssignOp assignOp = (JCTree.JCAssignOp)jCTree2;
                yield 2 + (assignOp.lhs == leaf ? 1 : 0);
            }
            case 3 -> {
                JCTree.JCUnary unused = (JCTree.JCUnary)jCTree2;
                yield TreeInfo.opPrec(parent.getTag());
            }
            case 4 -> {
                JCTree.JCBinary binary = (JCTree.JCBinary)jCTree2;
                yield TreeInfo.opPrec(parent.getTag()) + (binary.rhs == leaf ? 1 : 0);
            }
            case 5 -> {
                JCTree.JCTypeCast typeCast = (JCTree.JCTypeCast)jCTree2;
                if (typeCast.expr == leaf) {
                    yield 14;
                }
                yield 0;
            }
            case 6 -> {
                JCTree.JCInstanceOf instanceOf = (JCTree.JCInstanceOf)jCTree2;
                yield 10 + (instanceOf.getType() == leaf ? 1 : 0);
            }
            case 7 -> {
                JCTree.JCArrayAccess arrayAccess = (JCTree.JCArrayAccess)jCTree2;
                if (arrayAccess.indexed == leaf) {
                    yield 15;
                }
                yield 0;
            }
            case 8 -> {
                JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)jCTree2;
                if (fieldAccess.selected == leaf) {
                    yield 15;
                }
                yield 0;
            }
            default -> 0;
        };
    }
}

