/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.auto.value.AutoBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.time.AutoBuilder_InvalidJavaTimeConstant_JavaTimeType_Builder;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.time.DateTimeException;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.List;

@BugPattern(summary="This checker errors on calls to java.time methods using values that are guaranteed to throw a DateTimeException.", severity=BugPattern.SeverityLevel.ERROR)
public final class InvalidJavaTimeConstant
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final JavaTimeType DAY_OF_WEEK_APIS = JavaTimeType.builder().setClassName("java.time.DayOfWeek").addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_WEEK)).build();
    private static final JavaTimeType MONTH_APIS = JavaTimeType.builder().setClassName("java.time.Month").addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.MONTH_OF_YEAR)).build();
    private static final JavaTimeType YEAR_APIS = JavaTimeType.builder().setClassName("java.time.Year").addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.YEAR)).addInstanceMethod("atDay", InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_YEAR)).addInstanceMethod("atMonth", InvalidJavaTimeConstant.intP(ChronoField.MONTH_OF_YEAR)).build();
    private static final JavaTimeType YEAR_MONTH_APIS = JavaTimeType.builder().setClassName("java.time.YearMonth").addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.YEAR), InvalidJavaTimeConstant.intP(ChronoField.MONTH_OF_YEAR)).addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.YEAR), InvalidJavaTimeConstant.monthP(ChronoField.MONTH_OF_YEAR)).addInstanceMethod("atDay", InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_MONTH)).addInstanceMethod("withMonth", InvalidJavaTimeConstant.intP(ChronoField.MONTH_OF_YEAR)).addInstanceMethod("withYear", InvalidJavaTimeConstant.intP(ChronoField.YEAR)).build();
    private static final JavaTimeType MONTH_DAY_APIS = JavaTimeType.builder().setClassName("java.time.MonthDay").addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.MONTH_OF_YEAR), InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_MONTH)).addStaticMethod("of", InvalidJavaTimeConstant.monthP(ChronoField.MONTH_OF_YEAR), InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_MONTH)).addInstanceMethod("atYear", InvalidJavaTimeConstant.intP(ChronoField.YEAR)).addInstanceMethod("withDayOfMonth", InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_MONTH)).addInstanceMethod("withMonth", InvalidJavaTimeConstant.intP(ChronoField.MONTH_OF_YEAR)).build();
    private static final JavaTimeType LOCAL_TIME_APIS = JavaTimeType.builder().setClassName("java.time.LocalTime").addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.HOUR_OF_DAY), InvalidJavaTimeConstant.intP(ChronoField.MINUTE_OF_HOUR)).addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.HOUR_OF_DAY), InvalidJavaTimeConstant.intP(ChronoField.MINUTE_OF_HOUR), InvalidJavaTimeConstant.intP(ChronoField.SECOND_OF_MINUTE)).addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.HOUR_OF_DAY), InvalidJavaTimeConstant.intP(ChronoField.MINUTE_OF_HOUR), InvalidJavaTimeConstant.intP(ChronoField.SECOND_OF_MINUTE), InvalidJavaTimeConstant.intP(ChronoField.NANO_OF_SECOND)).addStaticMethod("ofNanoOfDay", InvalidJavaTimeConstant.longP(ChronoField.NANO_OF_DAY)).addStaticMethod("ofSecondOfDay", InvalidJavaTimeConstant.longP(ChronoField.SECOND_OF_DAY)).addInstanceMethod("withHour", InvalidJavaTimeConstant.intP(ChronoField.HOUR_OF_DAY)).addInstanceMethod("withMinute", InvalidJavaTimeConstant.intP(ChronoField.MINUTE_OF_HOUR)).addInstanceMethod("withNano", InvalidJavaTimeConstant.intP(ChronoField.NANO_OF_SECOND)).addInstanceMethod("withSecond", InvalidJavaTimeConstant.intP(ChronoField.SECOND_OF_MINUTE)).build();
    private static final JavaTimeType LOCAL_DATE_APIS = JavaTimeType.builder().setClassName("java.time.LocalDate").addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.YEAR), InvalidJavaTimeConstant.intP(ChronoField.MONTH_OF_YEAR), InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_MONTH)).addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.YEAR), InvalidJavaTimeConstant.monthP(ChronoField.MONTH_OF_YEAR), InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_MONTH)).addStaticMethod("ofEpochDay", InvalidJavaTimeConstant.longP(ChronoField.EPOCH_DAY)).addStaticMethod("ofYearDay", InvalidJavaTimeConstant.intP(ChronoField.YEAR), InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_YEAR)).addInstanceMethod("withDayOfMonth", InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_MONTH)).addInstanceMethod("withDayOfYear", InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_YEAR)).addInstanceMethod("withMonth", InvalidJavaTimeConstant.intP(ChronoField.MONTH_OF_YEAR)).addInstanceMethod("withYear", InvalidJavaTimeConstant.intP(ChronoField.YEAR)).build();
    private static final JavaTimeType LOCAL_DATE_TIME_APIS = JavaTimeType.builder().setClassName("java.time.LocalDateTime").addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.YEAR), InvalidJavaTimeConstant.intP(ChronoField.MONTH_OF_YEAR), InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_MONTH), InvalidJavaTimeConstant.intP(ChronoField.HOUR_OF_DAY), InvalidJavaTimeConstant.intP(ChronoField.MINUTE_OF_HOUR)).addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.YEAR), InvalidJavaTimeConstant.monthP(ChronoField.MONTH_OF_YEAR), InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_MONTH), InvalidJavaTimeConstant.intP(ChronoField.HOUR_OF_DAY), InvalidJavaTimeConstant.intP(ChronoField.MINUTE_OF_HOUR)).addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.YEAR), InvalidJavaTimeConstant.intP(ChronoField.MONTH_OF_YEAR), InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_MONTH), InvalidJavaTimeConstant.intP(ChronoField.HOUR_OF_DAY), InvalidJavaTimeConstant.intP(ChronoField.MINUTE_OF_HOUR), InvalidJavaTimeConstant.intP(ChronoField.SECOND_OF_MINUTE)).addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.YEAR), InvalidJavaTimeConstant.monthP(ChronoField.MONTH_OF_YEAR), InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_MONTH), InvalidJavaTimeConstant.intP(ChronoField.HOUR_OF_DAY), InvalidJavaTimeConstant.intP(ChronoField.MINUTE_OF_HOUR), InvalidJavaTimeConstant.intP(ChronoField.SECOND_OF_MINUTE)).addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.YEAR), InvalidJavaTimeConstant.intP(ChronoField.MONTH_OF_YEAR), InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_MONTH), InvalidJavaTimeConstant.intP(ChronoField.HOUR_OF_DAY), InvalidJavaTimeConstant.intP(ChronoField.MINUTE_OF_HOUR), InvalidJavaTimeConstant.intP(ChronoField.SECOND_OF_MINUTE), InvalidJavaTimeConstant.intP(ChronoField.NANO_OF_SECOND)).addStaticMethod("of", InvalidJavaTimeConstant.intP(ChronoField.YEAR), InvalidJavaTimeConstant.monthP(ChronoField.MONTH_OF_YEAR), InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_MONTH), InvalidJavaTimeConstant.intP(ChronoField.HOUR_OF_DAY), InvalidJavaTimeConstant.intP(ChronoField.MINUTE_OF_HOUR), InvalidJavaTimeConstant.intP(ChronoField.SECOND_OF_MINUTE), InvalidJavaTimeConstant.intP(ChronoField.NANO_OF_SECOND)).addInstanceMethod("withDayOfMonth", InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_MONTH)).addInstanceMethod("withDayOfYear", InvalidJavaTimeConstant.intP(ChronoField.DAY_OF_YEAR)).addInstanceMethod("withHour", InvalidJavaTimeConstant.intP(ChronoField.HOUR_OF_DAY)).addInstanceMethod("withMinute", InvalidJavaTimeConstant.intP(ChronoField.MINUTE_OF_HOUR)).addInstanceMethod("withMonth", InvalidJavaTimeConstant.intP(ChronoField.MONTH_OF_YEAR)).addInstanceMethod("withNano", InvalidJavaTimeConstant.intP(ChronoField.NANO_OF_SECOND)).addInstanceMethod("withSecond", InvalidJavaTimeConstant.intP(ChronoField.SECOND_OF_MINUTE)).addInstanceMethod("withYear", InvalidJavaTimeConstant.intP(ChronoField.YEAR)).build();
    private static final ImmutableMap<String, JavaTimeType> APIS = Maps.uniqueIndex((Iterable)ImmutableList.of((Object)LOCAL_TIME_APIS, (Object)LOCAL_DATE_APIS, (Object)LOCAL_DATE_TIME_APIS, (Object)DAY_OF_WEEK_APIS, (Object)MONTH_APIS, (Object)YEAR_APIS, (Object)MONTH_DAY_APIS, (Object)YEAR_MONTH_APIS), JavaTimeType::className);
    private static final Matcher<ExpressionTree> JAVA_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.packageStartsWith((String)"java."), Matchers.packageStartsWith((String)"tck.java.")});

    private static Param intP(ChronoField unit) {
        return new Param("int", unit);
    }

    private static Param longP(ChronoField unit) {
        return new Param("long", unit);
    }

    private static Param monthP(ChronoField unit) {
        return new Param("java.time.Month", unit);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (JAVA_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Type receiverType = ASTHelpers.getReceiverType((ExpressionTree)tree);
        if (receiverType == null) {
            return Description.NO_MATCH;
        }
        JavaTimeType type = (JavaTimeType)APIS.get((Object)receiverType.toString());
        if (type == null) {
            return Description.NO_MATCH;
        }
        for (MatcherWithUnits matcherWithUnits : type.methods()) {
            if (!matcherWithUnits.matcher().matches((Tree)tree, state)) continue;
            List<? extends ExpressionTree> arguments = tree.getArguments();
            for (int i = 0; i < arguments.size(); ++i) {
                ExpressionTree argument = arguments.get(i);
                Number constant = (Number)ASTHelpers.constValue((Tree)argument, Number.class);
                if (constant == null) continue;
                try {
                    ((ChronoField)matcherWithUnits.units().get(i)).checkValidValue(constant.longValue());
                    continue;
                }
                catch (DateTimeException invalid) {
                    return this.buildDescription(argument).setMessage(invalid.getMessage()).build();
                }
            }
            return Description.NO_MATCH;
        }
        return Description.NO_MATCH;
    }

    record Param(String type, ChronoField unit) {
    }

    record JavaTimeType(String className, ImmutableList<MatcherWithUnits> methods) {
        public static Builder builder() {
            return new AutoBuilder_InvalidJavaTimeConstant_JavaTimeType_Builder();
        }

        @AutoBuilder
        public static abstract class Builder {
            public abstract Builder setClassName(String var1);

            abstract String className();

            abstract ImmutableList.Builder<MatcherWithUnits> methodsBuilder();

            @CanIgnoreReturnValue
            public Builder addStaticMethod(String methodName, Param ... params) {
                this.methodsBuilder().add((Object)new MatcherWithUnits((Matcher<ExpressionTree>)MethodMatchers.staticMethod().onClass(this.className()).named(methodName).withParameters(Builder.getParameterTypes(params)), Builder.getParameterUnits(params)));
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addInstanceMethod(String methodName, Param ... params) {
                this.methodsBuilder().add((Object)new MatcherWithUnits((Matcher<ExpressionTree>)MethodMatchers.instanceMethod().onExactClass(this.className()).named(methodName).withParameters(Builder.getParameterTypes(params)), Builder.getParameterUnits(params)));
                return this;
            }

            private static ImmutableList<ChronoField> getParameterUnits(Param ... params) {
                return (ImmutableList)Arrays.stream(params).map(p -> p.unit()).collect(ImmutableList.toImmutableList());
            }

            private static ImmutableList<String> getParameterTypes(Param ... params) {
                return (ImmutableList)Arrays.stream(params).map(p -> p.type()).collect(ImmutableList.toImmutableList());
            }

            public abstract JavaTimeType build();
        }
    }

    record MatcherWithUnits(Matcher<ExpressionTree> matcher, ImmutableList<ChronoField> units) {
    }
}

