/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.VisitorState;
import com.google.errorprone.fixes.ErrorPronePosition;
import com.google.errorprone.fixes.FixedPosition;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.names.LevenshteinEditDistance;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.JCTree;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Optional;
import javax.lang.model.element.ElementKind;
import org.jspecify.annotations.Nullable;

final class Utils {
    private static final Method COMMENT_TREE_METHOD = Utils.getCommentTreeMethod();

    static Optional<String> getBestMatch(String to, int maxEditDistance, Iterable<String> choices) {
        String bestMatch = null;
        int minDistance = Integer.MAX_VALUE;
        for (String choice : choices) {
            int distance = LevenshteinEditDistance.getEditDistance((String)to, (String)choice);
            if (distance >= minDistance || distance >= maxEditDistance) continue;
            bestMatch = choice;
            minDistance = distance;
        }
        return Optional.ofNullable(bestMatch);
    }

    static DCTree.DCDocComment getDocComment(VisitorState state, Tree tree) {
        return Utils.getCommentTree(((JCTree.JCCompilationUnit)state.getPath().getCompilationUnit()).docComments, (JCTree)tree);
    }

    private static Method getCommentTreeMethod() {
        try {
            return DocCommentTable.class.getMethod("getCommentTree", JCTree.class);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static DCTree.DCDocComment getCommentTree(DocCommentTable docCommentTable, JCTree tree) {
        try {
            return (DCTree.DCDocComment)COMMENT_TREE_METHOD.invoke((Object)docCommentTable, tree);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    static SuggestedFix replace(DocTree docTree, String replacement, VisitorState state) {
        DocSourcePositions positions = JavacTrees.instance(state.context).getSourcePositions();
        CompilationUnitTree compilationUnitTree = state.getPath().getCompilationUnit();
        int startPos = Utils.getStartPosition(docTree, state);
        int endPos = (int)positions.getEndPosition(compilationUnitTree, Utils.getDocCommentTree(state), docTree);
        if (startPos == -1 || endPos == -1) {
            return SuggestedFix.emptyFix();
        }
        return SuggestedFix.replace((int)startPos, (int)endPos, (String)replacement);
    }

    static int getStartPosition(DocTree docTree, VisitorState state) {
        DocSourcePositions positions = JavacTrees.instance(state.context).getSourcePositions();
        CompilationUnitTree compilationUnitTree = state.getPath().getCompilationUnit();
        return (int)positions.getStartPosition(compilationUnitTree, Utils.getDocCommentTree(state), docTree);
    }

    static int getEndPosition(DocTree docTree, VisitorState state) {
        DocSourcePositions positions = JavacTrees.instance(state.context).getSourcePositions();
        CompilationUnitTree compilationUnitTree = state.getPath().getCompilationUnit();
        return (int)positions.getEndPosition(compilationUnitTree, Utils.getDocCommentTree(state), docTree);
    }

    static ErrorPronePosition diagnosticPosition(DocTreePath path, VisitorState state) {
        int startPosition = Utils.getStartPosition(path.getLeaf(), state);
        Tree tree = path.getTreePath().getLeaf();
        if (startPosition == -1) {
            startPosition = ASTHelpers.getStartPosition((Tree)tree);
        }
        return Utils.getDiagnosticPosition(startPosition, tree);
    }

    static ErrorPronePosition getDiagnosticPosition(int startPosition, Tree tree) {
        return new FixedPosition(tree, startPosition);
    }

    static @Nullable DocTreePath getDocTreePath(VisitorState state) {
        DocCommentTree docCommentTree = Utils.getDocCommentTree(state);
        if (docCommentTree == null) {
            return null;
        }
        return new DocTreePath(state.getPath(), docCommentTree);
    }

    private static @Nullable DocCommentTree getDocCommentTree(VisitorState state) {
        return JavacTrees.instance(state.context).getDocCommentTree(state.getPath());
    }

    static ImmutableMap<Integer, TreePath> getJavadoccableTrees(CompilationUnitTree tree) {
        final HashMap javadoccablePositions = new HashMap();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitPackage(PackageTree packageTree, Void unused) {
                javadoccablePositions.put(ASTHelpers.getStartPosition((Tree)packageTree), this.getCurrentPath());
                return (Void)super.visitPackage(packageTree, null);
            }

            @Override
            public Void visitClass(ClassTree classTree, Void unused) {
                if (!(ASTHelpers.getSymbol((ClassTree)classTree).owner instanceof Symbol.MethodSymbol)) {
                    javadoccablePositions.put(ASTHelpers.getStartPosition((Tree)classTree), this.getCurrentPath());
                }
                return (Void)super.visitClass(classTree, null);
            }

            @Override
            public Void visitMethod(MethodTree methodTree, Void unused) {
                if (!ASTHelpers.isGeneratedConstructor((MethodTree)methodTree)) {
                    javadoccablePositions.put(ASTHelpers.getStartPosition((Tree)methodTree), this.getCurrentPath());
                }
                return (Void)super.visitMethod(methodTree, null);
            }

            @Override
            public Void visitVariable(VariableTree variableTree, Void unused) {
                ElementKind kind = ASTHelpers.getSymbol((VariableTree)variableTree).getKind();
                if (kind == ElementKind.FIELD) {
                    javadoccablePositions.put(ASTHelpers.getStartPosition((Tree)variableTree), this.getCurrentPath());
                }
                if (kind == ElementKind.ENUM_CONSTANT) {
                    javadoccablePositions.put(ASTHelpers.getStartPosition((Tree)variableTree), this.getCurrentPath());
                    ExpressionTree expressionTree = variableTree.getInitializer();
                    if (expressionTree instanceof NewClassTree) {
                        NewClassTree newClassTree = (NewClassTree)expressionTree;
                        ClassTree classBody = newClassTree.getClassBody();
                        if (classBody != null) {
                            this.scan(classBody.getMembers(), null);
                        }
                        return null;
                    }
                }
                return (Void)super.visitVariable(variableTree, null);
            }

            @Override
            public Void visitModule(ModuleTree moduleTree, Void unused) {
                javadoccablePositions.put(ASTHelpers.getStartPosition((Tree)moduleTree), this.getCurrentPath());
                return (Void)super.visitModule(moduleTree, null);
            }
        }.scan(tree, null);
        return ImmutableMap.copyOf(javadoccablePositions);
    }

    private Utils() {
    }
}

