/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inlineme;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inlineme.InlinabilityResult;
import com.google.errorprone.bugpatterns.inlineme.InlineMeData;
import com.google.errorprone.fixes.AppliedFix;
import com.google.errorprone.fixes.ErrorProneEndPosTable;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.google.errorprone.util.OperatorPrecedence;
import com.google.errorprone.util.SideEffectAnalysis;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

@BugPattern(name="InlineMeInliner", summary="Callers of this API should be inlined.", severity=BugPattern.SeverityLevel.WARNING, tags={"JavaInlineMe"})
public final class Inliner
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    public static final String FINDING_TAG = "JavaInlineMe";
    static final String PREFIX_FLAG = "InlineMe:Prefix";
    static final String SKIP_COMMENTS_FLAG = "InlineMe:SkipInliningsWithComments";
    private static final Splitter PACKAGE_SPLITTER = Splitter.on((char)'.');
    private static final String CHECK_FIX_COMPILES = "InlineMe:CheckFixCompiles";
    private static final String INLINE_ME = "InlineMe";
    private static final String VALIDATION_DISABLED = "InlineMeValidationDisabled";
    private final ImmutableSet<String> apiPrefixes;
    private final boolean skipCallsitesWithComments;
    private final boolean checkFixCompiles;

    @Inject
    Inliner(ErrorProneFlags flags) {
        this.apiPrefixes = flags.getSetOrEmpty(PREFIX_FLAG);
        this.skipCallsitesWithComments = flags.getBoolean(SKIP_COMMENTS_FLAG).orElse(true);
        this.checkFixCompiles = flags.getBoolean(CHECK_FIX_COMPILES).orElse(false);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((NewClassTree)tree);
        if (!ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol.MethodSymbol)symbol, (String)INLINE_ME)) {
            return Description.NO_MATCH;
        }
        String receiverString = "new " + state.getSourceForNode((Tree)tree.getIdentifier());
        return this.match(tree, symbol, tree.getArguments(), receiverString, null, state);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree methodSelectTree;
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (!ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol.MethodSymbol)symbol, (String)INLINE_ME)) {
            return Description.NO_MATCH;
        }
        String receiverString = "";
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (receiver != null) {
            receiverString = state.getSourceForNode((Tree)receiver);
        }
        if ((methodSelectTree = tree.getMethodSelect()) != null) {
            String methodSelect = state.getSourceForNode((Tree)methodSelectTree);
            if (methodSelect.equals("super")) {
                receiverString = methodSelect;
            }
            if (methodSelect.equals("this")) {
                receiverString = methodSelect;
            }
        }
        return this.match(tree, symbol, tree.getArguments(), receiverString, receiver, state);
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        IdentifierTree it;
        MethodInvocationTree mit;
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MemberReferenceTree)tree);
        if (symbol.isStatic()) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol.MethodSymbol)symbol, (String)INLINE_ME)) {
            return Description.NO_MATCH;
        }
        Optional<InlineMeData> inlineMeMaybe = InlineMeData.createFromSymbol(symbol);
        if (inlineMeMaybe.isEmpty()) {
            return Description.NO_MATCH;
        }
        InlineMeData inlineMe = inlineMeMaybe.get();
        if (!inlineMe.imports().isEmpty() || !inlineMe.staticImports().isEmpty()) {
            return Description.NO_MATCH;
        }
        Api api = Api.create(symbol, state);
        if (!this.matchesApiPrefixes(api)) {
            return Description.NO_MATCH;
        }
        if (this.skipCallsitesWithComments && ASTHelpers.stringContainsComments((CharSequence)state.getSourceForNode((Tree)tree), (Context)state.context)) {
            return Description.NO_MATCH;
        }
        JavacParser parser = Inliner.newParser(inlineMe.replacement(), state);
        ExpressionTree expressionTree = parser.parseExpression();
        if (!(expressionTree instanceof MethodInvocationTree && (mit = (MethodInvocationTree)expressionTree).getArguments().isEmpty() && (expressionTree = ASTHelpers.getReceiver((ExpressionTree)mit)) instanceof IdentifierTree && (it = (IdentifierTree)expressionTree).getName().contentEquals("this"))) {
            return Description.NO_MATCH;
        }
        String identifier = ((MemberSelectTree)mit.getMethodSelect()).getIdentifier().toString();
        SuggestedFix fix = SuggestedFix.replace((int)state.getEndPosition((Tree)tree.getQualifierExpression()), (int)state.getEndPosition((Tree)tree), (String)("::" + identifier));
        return this.maybeCheckFixCompiles(tree, state, fix, api);
    }

    private Description match(ExpressionTree tree, Symbol.MethodSymbol symbol, List<? extends ExpressionTree> callingVars, String receiverString, ExpressionTree receiver, VisitorState state) {
        boolean removedThisPrefix;
        ImmutableList callingVarStrings;
        Optional<InlineMeData> inlineMe = InlineMeData.createFromSymbol(symbol);
        if (inlineMe.isEmpty()) {
            return Description.NO_MATCH;
        }
        Api api = Api.create(symbol, state);
        if (!this.matchesApiPrefixes(api)) {
            return Description.NO_MATCH;
        }
        if (this.skipCallsitesWithComments && ASTHelpers.stringContainsComments((CharSequence)state.getSourceForNode((Tree)tree), (Context)state.context)) {
            return Description.NO_MATCH;
        }
        ImmutableList varNames = (ImmutableList)symbol.getParameters().stream().map(varSymbol -> ((Name)varSymbol.getSimpleName()).toString()).collect(ImmutableList.toImmutableList());
        boolean varargsWithEmptyArguments = false;
        if (symbol.isVarArgs()) {
            if (callingVars.size() == varNames.size() - 1) {
                varargsWithEmptyArguments = true;
                callingVarStrings = (ImmutableList)callingVars.stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(ImmutableList.toImmutableList());
            } else {
                List<? extends ExpressionTree> nonvarargs = callingVars.subList(0, varNames.size() - 1);
                String varargsJoined = callingVars.subList(varNames.size() - 1, callingVars.size()).stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(", "));
                callingVarStrings = ImmutableList.builderWithExpectedSize((int)varNames.size()).addAll((Iterable)nonvarargs.stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(ImmutableList.toImmutableList())).add((Object)varargsJoined).build();
            }
        } else {
            callingVarStrings = (ImmutableList)callingVars.stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(ImmutableList.toImmutableList());
        }
        String replacement = inlineMe.get().replacement();
        JavacParser parser = Inliner.newParser(replacement, state);
        JCTree.JCExpression replacementExpression = parser.parseExpression();
        SuggestedFix.Builder replacementFixes = SuggestedFix.builder();
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        for (String newImport : inlineMe.get().imports()) {
            String typeName = (String)Iterables.getLast((Iterable)PACKAGE_SPLITTER.split((CharSequence)newImport));
            String qualifiedTypeName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fixBuilder, (String)newImport);
            Inliner.visitIdentifiers(replacementExpression, (node, unused) -> {
                if (node.getName().contentEquals(typeName)) {
                    replacementFixes.replace((Tree)node, qualifiedTypeName);
                }
            });
        }
        for (String newStaticImport : inlineMe.get().staticImports()) {
            fixBuilder.addStaticImport(newStaticImport);
        }
        int replacementStart = ASTHelpers.getStartPosition((Tree)tree);
        int replacementEnd = state.getEndPosition((Tree)tree);
        boolean bl = removedThisPrefix = replacement.startsWith("this.") && receiver != null;
        if (removedThisPrefix) {
            replacementFixes.replace(0, "this".length(), "");
            replacementStart = state.getEndPosition((Tree)receiver);
        }
        if (Strings.isNullOrEmpty((String)receiverString)) {
            Inliner.visitIdentifiers(replacementExpression, (node, unused) -> {
                if (node.getName().contentEquals("this")) {
                    replacementFixes.replace(ASTHelpers.getStartPosition((Tree)node), parser.getEndPos((JCTree)((Object)node)) + 1, "");
                }
            });
        } else {
            Tree parent;
            if (replacement.equals("this") && (parent = state.getPath().getParentPath().getLeaf()) instanceof ExpressionStatementTree && !SideEffectAnalysis.hasSideEffect((ExpressionTree)receiver)) {
                return this.describe(parent, SuggestedFix.delete((Tree)parent), api);
            }
            Inliner.visitIdentifiers(replacementExpression, (node, unused) -> {
                if ((!removedThisPrefix || ASTHelpers.getStartPosition((Tree)node) != 0) && node.getName().contentEquals("this")) {
                    replacementFixes.replace(ASTHelpers.getStartPosition((Tree)node), parser.getEndPos((JCTree)((Object)node)), receiverString);
                }
            });
        }
        for (int i = 0; i < varNames.size(); ++i) {
            String varName = (String)varNames.get(i);
            if (InlinabilityResult.matchesArgN(varName)) {
                return Description.NO_MATCH;
            }
            boolean terminalVarargsReplacement = varargsWithEmptyArguments && i == varNames.size() - 1;
            String replacementResult = terminalVarargsReplacement ? "" : (String)callingVarStrings.get(i);
            boolean mayRequireParens = i < callingVars.size() && ASTHelpers.requiresParentheses((ExpressionTree)callingVars.get(i), (VisitorState)state);
            Inliner.visitIdentifiers(replacementExpression, (node, path) -> {
                boolean outerNeverRequiresParens;
                if (!node.getName().contentEquals(varName)) {
                    return;
                }
                boolean bl = outerNeverRequiresParens = path.size() < 2 || Inliner.getArguments((Tree)path.get(path.size() - 2)).contains(node);
                if (terminalVarargsReplacement) {
                    List<? extends ExpressionTree> calledMethodArguments = Inliner.getArguments((Tree)path.get(path.size() - 2));
                    replacementFixes.replace(calledMethodArguments.indexOf(node) == 0 ? ASTHelpers.getStartPosition((Tree)node) : parser.getEndPos((JCTree)((Object)calledMethodArguments.get(calledMethodArguments.indexOf(node) - 1))), parser.getEndPos((JCTree)((Object)node)), replacementResult);
                } else {
                    replacementFixes.replace((Tree)node, (String)(!outerNeverRequiresParens && mayRequireParens ? "(" + replacementResult + ")" : replacementResult));
                }
            });
        }
        String fixedReplacement = AppliedFix.applyReplacements((CharSequence)replacement, (ErrorProneEndPosTable)Inliner.asEndPosTable(parser), (Fix)replacementFixes.build());
        fixBuilder.replace(replacementStart, replacementEnd, Inliner.inliningRequiresParentheses(state.getPath(), replacementExpression) ? String.format("(%s)", fixedReplacement) : fixedReplacement);
        return this.maybeCheckFixCompiles(tree, state, fixBuilder.build(), api);
    }

    private static JavacParser newParser(String replacement, VisitorState state) {
        return ParserFactory.instance(state.context).newParser(replacement, true, true, true);
    }

    private static List<? extends ExpressionTree> getArguments(Tree tree) {
        Tree tree2 = tree;
        Objects.requireNonNull(tree2);
        Tree tree3 = tree2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MethodInvocationTree.class, NewClassTree.class}, (Object)tree3, n)) {
            case 0 -> {
                MethodInvocationTree mit = (MethodInvocationTree)tree3;
                yield mit.getArguments();
            }
            case 1 -> {
                NewClassTree nct = (NewClassTree)tree3;
                yield nct.getArguments();
            }
            default -> ImmutableList.of();
        };
    }

    private static boolean inliningRequiresParentheses(TreePath treePath, ExpressionTree replacement) {
        Tree originalExpression = treePath.getLeaf();
        Tree parent = treePath.getParentPath().getLeaf();
        Optional replacementPrecedence = OperatorPrecedence.optionallyFrom((Tree.Kind)replacement.getKind());
        Optional parentPrecedence = OperatorPrecedence.optionallyFrom((Tree.Kind)parent.getKind());
        if (replacementPrecedence.isPresent() && parentPrecedence.isPresent()) {
            return ((OperatorPrecedence)parentPrecedence.get()).isHigher((OperatorPrecedence)replacementPrecedence.get());
        }
        switch (parent.getKind()) {
            case RETURN: 
            case EXPRESSION_STATEMENT: {
                return false;
            }
            case VARIABLE: {
                if (!Objects.equals(((VariableTree)parent).getInitializer(), originalExpression)) break;
                return false;
            }
            case ASSIGNMENT: {
                if (!((AssignmentTree)parent).getExpression().equals(originalExpression)) break;
                return false;
            }
            case METHOD_INVOCATION: 
            case NEW_CLASS: {
                if (!Inliner.getArguments(parent).contains(originalExpression)) break;
                return false;
            }
        }
        switch (replacement.getKind()) {
            case METHOD_INVOCATION: 
            case NEW_CLASS: 
            case IDENTIFIER: 
            case MEMBER_SELECT: 
            case ARRAY_ACCESS: 
            case PARENTHESIZED: 
            case MEMBER_REFERENCE: {
                return false;
            }
        }
        if (replacement instanceof UnaryTree) {
            return parent instanceof MemberSelectTree;
        }
        return true;
    }

    private Description maybeCheckFixCompiles(ExpressionTree tree, VisitorState state, SuggestedFix fix, Api api) {
        if (this.checkFixCompiles && fix.getImportsToAdd().isEmpty()) {
            return SuggestedFixes.compilesWithFix((Fix)fix, (VisitorState)state) ? this.describe(tree, fix, api) : Description.NO_MATCH;
        }
        return this.describe(tree, fix, api);
    }

    private static void visitIdentifiers(Tree tree, final BiConsumer<IdentifierTree, List<Tree>> identifierConsumer) {
        new TreeScanner<Void, Void>(){
            private final List<Tree> path = new ArrayList<Tree>();

            @Override
            public Void scan(Tree tree, Void unused) {
                if (tree != null) {
                    this.path.add(tree);
                    super.scan(tree, null);
                    this.path.remove(this.path.size() - 1);
                }
                return null;
            }

            @Override
            public Void visitIdentifier(IdentifierTree node, Void unused) {
                identifierConsumer.accept(node, this.path);
                return (Void)super.visitIdentifier(node, null);
            }
        }.scan(tree, null);
    }

    private static ImmutableList<String> getStrings(Attribute.Compound attribute, String name) {
        return (ImmutableList)MoreAnnotations.getValue((Attribute.Compound)attribute, (String)name).map(MoreAnnotations::asStrings).orElse(Stream.empty()).collect(ImmutableList.toImmutableList());
    }

    private Description describe(Tree tree, SuggestedFix fix, Api api) {
        return this.buildDescription(tree).setMessage(api.message()).addFix((Fix)fix).build();
    }

    private boolean matchesApiPrefixes(Api api) {
        if (this.apiPrefixes.isEmpty()) {
            return true;
        }
        for (String apiPrefix : this.apiPrefixes) {
            if (!api.methodId().startsWith(apiPrefix)) continue;
            return true;
        }
        return false;
    }

    private static ErrorProneEndPosTable asEndPosTable(JavacParser parser) {
        return tree -> parser.getEndPos((JCTree)tree);
    }

    private record Api(String className, String methodName, String packageName, boolean isConstructor, boolean isDeprecated, String extraMessage) {
        private static final Splitter CLASS_NAME_SPLITTER = Splitter.on((char)'.');

        static Api create(Symbol.MethodSymbol method, VisitorState state) {
            Object extraMessage = "";
            if (ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol.MethodSymbol)method, (String)Inliner.VALIDATION_DISABLED)) {
                Attribute.Compound inlineMeValidationDisabled = (Attribute.Compound)method.getRawAttributes().stream().filter(a -> ((Name)a.type.tsym.getSimpleName()).contentEquals(Inliner.VALIDATION_DISABLED)).collect(MoreCollectors.onlyElement());
                String reason = (String)Iterables.getOnlyElement(Inliner.getStrings(inlineMeValidationDisabled, "value"));
                extraMessage = " NOTE: this is an unvalidated inlining! Reasoning: " + reason;
            }
            return new Api(method.owner.getQualifiedName().toString(), ((Name)method.getSimpleName()).toString(), ASTHelpers.enclosingPackage((Symbol)method).toString(), method.isConstructor(), ASTHelpers.hasAnnotation((Symbol)method, (String)"java.lang.Deprecated", (VisitorState)state), (String)extraMessage);
        }

        final String message() {
            return "Migrate (via inlining) away from " + (this.isDeprecated() ? "deprecated " : "") + this.shortName() + "." + this.extraMessage();
        }

        final String methodId() {
            return String.format("%s#%s", this.className(), this.methodName());
        }

        final String shortName() {
            String humanReadableClassName = this.className().replaceFirst(this.packageName() + ".", "");
            return String.format("`%s.%s()`", humanReadableClassName, this.methodName());
        }

        final String simpleClassName() {
            return (String)Iterables.getLast((Iterable)CLASS_NAME_SPLITTER.split((CharSequence)this.className()));
        }
    }
}

