/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.errorprone.VisitorState;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public abstract class AbstractCollectionIncompatibleTypeMatcher {
    abstract Matcher<ExpressionTree> methodMatcher();

    abstract @Nullable Type extractSourceType(MethodInvocationTree var1, VisitorState var2);

    abstract @Nullable Type extractSourceType(MemberReferenceTree var1, VisitorState var2);

    abstract @Nullable ExpressionTree extractSourceTree(MethodInvocationTree var1, VisitorState var2);

    abstract @Nullable ExpressionTree extractSourceTree(MemberReferenceTree var1, VisitorState var2);

    abstract @Nullable Type extractTargetType(MethodInvocationTree var1, VisitorState var2);

    abstract @Nullable Type extractTargetType(MemberReferenceTree var1, VisitorState var2);

    public final @Nullable MatchResult matches(ExpressionTree tree, final VisitorState state) {
        if (!this.methodMatcher().matches((Tree)tree, state)) {
            return null;
        }
        return (MatchResult)new SimpleTreeVisitor<MatchResult, Void>(this){
            final /* synthetic */ AbstractCollectionIncompatibleTypeMatcher this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public MatchResult visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void unused) {
                return this.this$0.getMatchResult(this.this$0.extractSourceTree(methodInvocationTree, state), this.this$0.extractSourceType(methodInvocationTree, state), this.this$0.extractTargetType(methodInvocationTree, state));
            }

            @Override
            public MatchResult visitMemberReference(MemberReferenceTree memberReferenceTree, Void unused) {
                return this.this$0.getMatchResult(this.this$0.extractSourceTree(memberReferenceTree, state), this.this$0.extractSourceType(memberReferenceTree, state), this.this$0.extractTargetType(memberReferenceTree, state));
            }
        }.visit(tree, null);
    }

    private @Nullable MatchResult getMatchResult(@Nullable ExpressionTree sourceTree, @Nullable Type sourceType, @Nullable Type targetType) {
        if (sourceTree == null || sourceType == null || targetType == null) {
            return null;
        }
        return MatchResult.create(sourceTree, sourceType, targetType, this);
    }

    protected static @Nullable Type extractTypeArgAsMemberOfSupertype(Type type, Symbol superTypeSym, int typeArgIndex, Types types) {
        Type collectionType = types.asSuper(type, superTypeSym);
        if (collectionType == null) {
            return null;
        }
        List<Type> tyargs = collectionType.getTypeArguments();
        if (tyargs.size() <= typeArgIndex) {
            return null;
        }
        return tyargs.get(typeArgIndex);
    }

    Optional<Fix> buildFix(MatchResult result) {
        return Optional.empty();
    }

    protected String message(MatchResult result, String sourceType, String targetType) {
        return String.format("Argument '%s' should not be passed to this method; its type %s is not compatible with %s", result.sourceTree(), sourceType, targetType);
    }

    public record MatchResult(ExpressionTree sourceTree, Type sourceType, Type targetType, AbstractCollectionIncompatibleTypeMatcher matcher) {
        public static MatchResult create(ExpressionTree sourceTree, Type sourceType, Type targetType, AbstractCollectionIncompatibleTypeMatcher matcher) {
            return new MatchResult(sourceTree, sourceType, targetType, matcher);
        }

        public String message(String sourceType, String targetType) {
            return this.matcher().message(this, sourceType, targetType);
        }

        public Optional<Fix> buildFix() {
            return this.matcher().buildFix(this);
        }
    }
}

